/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import com.facebook.stetho.common.ThreadBound;
import com.facebook.stetho.common.UncheckedCallable;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.common.android.HandlerUtil;
import com.facebook.stetho.inspector.elements.DocumentProvider;
import com.facebook.stetho.inspector.elements.DocumentProviderFactory;
import com.facebook.stetho.inspector.elements.android.AndroidDocumentProvider;

public final class AndroidDocumentProviderFactory
implements DocumentProviderFactory,
ThreadBound {
    private final Application mApplication;
    private final Handler mHandler;

    public AndroidDocumentProviderFactory(Application application) {
        this.mApplication = Util.throwIfNull(application);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public DocumentProvider create() {
        return new AndroidDocumentProvider(this.mApplication, this);
    }

    @Override
    public boolean checkThreadAccess() {
        return HandlerUtil.checkThreadAccess(this.mHandler);
    }

    @Override
    public void verifyThreadAccess() {
        HandlerUtil.verifyThreadAccess(this.mHandler);
    }

    @Override
    public <V> V postAndWait(UncheckedCallable<V> c) {
        return HandlerUtil.postAndWait(this.mHandler, c);
    }

    @Override
    public void postAndWait(Runnable r) {
        HandlerUtil.postAndWait(this.mHandler, r);
    }

    @Override
    public void postDelayed(Runnable r, long delayMillis) {
        if (!this.mHandler.postDelayed(r, delayMillis)) {
            throw new RuntimeException("Handler.postDelayed() returned false");
        }
    }

    @Override
    public void removeCallbacks(Runnable r) {
        this.mHandler.removeCallbacks(r);
    }
}

