/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.Predicate;
import com.facebook.stetho.common.ThreadBound;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.common.android.ViewUtil;
import com.facebook.stetho.inspector.elements.Descriptor;
import com.facebook.stetho.inspector.elements.DescriptorMap;
import com.facebook.stetho.inspector.elements.DocumentProvider;
import com.facebook.stetho.inspector.elements.DocumentProviderListener;
import com.facebook.stetho.inspector.elements.NodeDescriptor;
import com.facebook.stetho.inspector.elements.ObjectDescriptor;
import com.facebook.stetho.inspector.elements.android.ActivityDescriptor;
import com.facebook.stetho.inspector.elements.android.AndroidDescriptorHost;
import com.facebook.stetho.inspector.elements.android.AndroidDocumentRoot;
import com.facebook.stetho.inspector.elements.android.ApplicationDescriptor;
import com.facebook.stetho.inspector.elements.android.DialogDescriptor;
import com.facebook.stetho.inspector.elements.android.DialogFragmentDescriptor;
import com.facebook.stetho.inspector.elements.android.DocumentHiddenView;
import com.facebook.stetho.inspector.elements.android.FragmentDescriptor;
import com.facebook.stetho.inspector.elements.android.HighlightableDescriptor;
import com.facebook.stetho.inspector.elements.android.TextViewDescriptor;
import com.facebook.stetho.inspector.elements.android.ViewDescriptor;
import com.facebook.stetho.inspector.elements.android.ViewGroupDescriptor;
import com.facebook.stetho.inspector.elements.android.ViewHighlighter;
import com.facebook.stetho.inspector.elements.android.WindowDescriptor;
import com.facebook.stetho.inspector.helper.ThreadBoundProxy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class AndroidDocumentProvider
extends ThreadBoundProxy
implements DocumentProvider,
AndroidDescriptorHost {
    private static final int INSPECT_OVERLAY_COLOR = 0x40FFFFFF;
    private static final int INSPECT_HOVER_COLOR = 0x404040FF;
    private final Application mApplication;
    private final DescriptorMap mDescriptorMap;
    private final AndroidDocumentRoot mDocumentRoot;
    private final ViewHighlighter mHighlighter;
    private final InspectModeHandler mInspectModeHandler;
    @Nullable
    private DocumentProviderListener mListener;
    private static final long REPORT_CHANGED_INTERVAL_MS = 1000L;
    private boolean mIsReportChangesTimerPosted = false;
    private final Runnable mReportChangesTimer = new Runnable(){

        @Override
        public void run() {
            AndroidDocumentProvider.this.mIsReportChangesTimerPosted = false;
            if (AndroidDocumentProvider.this.mListener != null) {
                AndroidDocumentProvider.this.mListener.onPossiblyChanged();
                AndroidDocumentProvider.this.mIsReportChangesTimerPosted = true;
                AndroidDocumentProvider.this.postDelayed(this, 1000L);
            }
        }
    };

    public AndroidDocumentProvider(Application application, ThreadBound enforcer) {
        super(enforcer);
        this.mApplication = Util.throwIfNull(application);
        this.mDocumentRoot = new AndroidDocumentRoot(application);
        this.mDescriptorMap = new DescriptorMap().beginInit().register(Activity.class, new ActivityDescriptor()).register(AndroidDocumentRoot.class, this.mDocumentRoot).register(Application.class, new ApplicationDescriptor()).register(Dialog.class, new DialogDescriptor());
        DialogFragmentDescriptor.register(this.mDescriptorMap);
        FragmentDescriptor.register(this.mDescriptorMap).register(Object.class, new ObjectDescriptor()).register(TextView.class, new TextViewDescriptor()).register(View.class, new ViewDescriptor()).register(ViewGroup.class, new ViewGroupDescriptor()).register(Window.class, new WindowDescriptor()).setHost(this).endInit();
        this.mHighlighter = ViewHighlighter.newInstance();
        this.mInspectModeHandler = new InspectModeHandler();
    }

    @Override
    public void dispose() {
        this.verifyThreadAccess();
        this.mHighlighter.clearHighlight();
        this.mInspectModeHandler.disable();
        this.removeCallbacks(this.mReportChangesTimer);
        this.mIsReportChangesTimerPosted = false;
        this.mListener = null;
    }

    @Override
    public void setListener(DocumentProviderListener listener) {
        this.verifyThreadAccess();
        this.mListener = listener;
        if (this.mListener == null && this.mIsReportChangesTimerPosted) {
            this.mIsReportChangesTimerPosted = false;
            this.removeCallbacks(this.mReportChangesTimer);
        } else if (this.mListener != null && !this.mIsReportChangesTimerPosted) {
            this.mIsReportChangesTimerPosted = true;
            this.postDelayed(this.mReportChangesTimer, 1000L);
        }
    }

    @Override
    public Object getRootElement() {
        this.verifyThreadAccess();
        return this.mDocumentRoot;
    }

    @Override
    public NodeDescriptor getNodeDescriptor(Object element) {
        this.verifyThreadAccess();
        return this.getDescriptor(element);
    }

    @Override
    public void highlightElement(Object element, int color2) {
        this.verifyThreadAccess();
        View highlightingView = this.getHighlightingView(element);
        if (highlightingView == null) {
            this.mHighlighter.clearHighlight();
        } else {
            this.mHighlighter.setHighlightedView(highlightingView, color2);
        }
    }

    @Override
    public void hideHighlight() {
        this.verifyThreadAccess();
        this.mHighlighter.clearHighlight();
    }

    @Override
    public void setInspectModeEnabled(boolean enabled) {
        this.verifyThreadAccess();
        if (enabled) {
            this.mInspectModeHandler.enable();
        } else {
            this.mInspectModeHandler.disable();
        }
    }

    @Override
    public void setAttributesAsText(Object element, String text) {
        this.verifyThreadAccess();
        Descriptor descriptor = this.mDescriptorMap.get(element.getClass());
        if (descriptor != null) {
            descriptor.setAttributesAsText(element, text);
        }
    }

    @Override
    public Descriptor getDescriptor(Object element) {
        return element == null ? null : this.mDescriptorMap.get(element.getClass());
    }

    @Override
    public void onAttributeModified(Object element, String name, String value) {
        if (this.mListener != null) {
            this.mListener.onAttributeModified(element, name, value);
        }
    }

    @Override
    public void onAttributeRemoved(Object element, String name) {
        if (this.mListener != null) {
            this.mListener.onAttributeRemoved(element, name);
        }
    }

    @Override
    public View getHighlightingView(Object element) {
        if (element == null) {
            return null;
        }
        View highlightingView = null;
        Descriptor lastDescriptor = null;
        for (Class<?> theClass = element.getClass(); highlightingView == null && theClass != null; theClass = theClass.getSuperclass()) {
            Descriptor descriptor = this.mDescriptorMap.get(theClass);
            if (descriptor == null) {
                return null;
            }
            if (descriptor != lastDescriptor && descriptor instanceof HighlightableDescriptor) {
                highlightingView = ((HighlightableDescriptor)((Object)descriptor)).getViewForHighlighting(element);
            }
            lastDescriptor = descriptor;
        }
        return highlightingView;
    }

    private void getWindows(final Accumulator<Window> accumulator) {
        Descriptor appDescriptor = this.getDescriptor(this.mApplication);
        if (appDescriptor != null) {
            Accumulator<Object> elementAccumulator = new Accumulator<Object>(){

                @Override
                public void store(Object element) {
                    if (element instanceof Window) {
                        accumulator.store((Window)element);
                    } else {
                        Descriptor elementDescriptor = AndroidDocumentProvider.this.getDescriptor(element);
                        if (elementDescriptor != null) {
                            elementDescriptor.getChildren(element, this);
                        }
                    }
                }
            };
            appDescriptor.getChildren(this.mApplication, elementAccumulator);
        }
    }

    private final class InspectModeHandler {
        private final Predicate<View> mViewSelector = new Predicate<View>(){

            @Override
            public boolean apply(View view) {
                return !(view instanceof DocumentHiddenView);
            }
        };
        private List<View> mOverlays;

        private InspectModeHandler() {
        }

        public void enable() {
            AndroidDocumentProvider.this.verifyThreadAccess();
            if (this.mOverlays != null) {
                this.disable();
            }
            this.mOverlays = new ArrayList<View>();
            AndroidDocumentProvider.this.getWindows(new Accumulator<Window>(){

                @Override
                public void store(Window object) {
                    if (object.peekDecorView() instanceof ViewGroup) {
                        ViewGroup decorView = (ViewGroup)object.peekDecorView();
                        OverlayView overlayView = new OverlayView((Context)AndroidDocumentProvider.this.mApplication);
                        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
                        layoutParams.width = -1;
                        layoutParams.height = -1;
                        decorView.addView((View)overlayView, (ViewGroup.LayoutParams)layoutParams);
                        decorView.bringChildToFront((View)overlayView);
                        InspectModeHandler.this.mOverlays.add(overlayView);
                    }
                }
            });
        }

        public void disable() {
            AndroidDocumentProvider.this.verifyThreadAccess();
            if (this.mOverlays == null) {
                return;
            }
            for (int i = 0; i < this.mOverlays.size(); ++i) {
                View overlayView = this.mOverlays.get(i);
                ViewGroup decorViewGroup = (ViewGroup)overlayView.getParent();
                decorViewGroup.removeView(overlayView);
            }
            this.mOverlays = null;
        }

        private final class OverlayView
        extends DocumentHiddenView {
            public OverlayView(Context context) {
                super(context);
            }

            protected void onDraw(Canvas canvas) {
                canvas.drawColor(0x40FFFFFF);
                super.onDraw(canvas);
            }

            public boolean onTouchEvent(MotionEvent event) {
                if (this.getParent() instanceof View) {
                    View parent = (View)this.getParent();
                    View view = ViewUtil.hitTest(parent, event.getX(), event.getY(), InspectModeHandler.this.mViewSelector);
                    if (event.getAction() != 3 && view != null) {
                        AndroidDocumentProvider.this.mHighlighter.setHighlightedView(view, 0x404040FF);
                        if (event.getAction() == 1 && AndroidDocumentProvider.this.mListener != null) {
                            AndroidDocumentProvider.this.mListener.onInspectRequested(view);
                        }
                    }
                }
                return true;
            }
        }
    }
}

