/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import com.facebook.stetho.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ActivityTracker {
    private static final ActivityTracker sInstance = new ActivityTracker();
    @GuardedBy(value="Looper.getMainLooper()")
    private final ArrayList<Activity> mActivities = new ArrayList();
    private final List<Activity> mActivitiesUnmodifiable = Collections.unmodifiableList(this.mActivities);
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    @Nullable
    private AutomaticTracker mAutomaticTracker;

    public static ActivityTracker get() {
        return sInstance;
    }

    public void registerListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    public boolean beginTrackingIfPossible(Application application) {
        AutomaticTracker automaticTracker;
        if (this.mAutomaticTracker == null && (automaticTracker = AutomaticTracker.newInstanceIfPossible(application, this)) != null) {
            automaticTracker.register();
            this.mAutomaticTracker = automaticTracker;
            return true;
        }
        return false;
    }

    public boolean endTracking() {
        if (this.mAutomaticTracker != null) {
            this.mAutomaticTracker.unregister();
            this.mAutomaticTracker = null;
            return true;
        }
        return false;
    }

    public void add(Activity activity) {
        Util.throwIfNull(activity);
        Util.throwIfNot(Looper.myLooper() == Looper.getMainLooper());
        this.mActivities.add(activity);
        for (Listener listener : this.mListeners) {
            listener.onActivityAdded(activity);
        }
    }

    public void remove(Activity activity) {
        Util.throwIfNull(activity);
        Util.throwIfNot(Looper.myLooper() == Looper.getMainLooper());
        if (this.mActivities.remove(activity)) {
            for (Listener listener : this.mListeners) {
                listener.onActivityRemoved(activity);
            }
        }
    }

    public List<Activity> getActivitiesView() {
        return this.mActivitiesUnmodifiable;
    }

    public Activity tryGetTopActivity() {
        if (this.mActivitiesUnmodifiable.isEmpty()) {
            return null;
        }
        return this.mActivitiesUnmodifiable.get(this.mActivitiesUnmodifiable.size() - 1);
    }

    private static abstract class AutomaticTracker {
        private AutomaticTracker() {
        }

        @Nullable
        public static AutomaticTracker newInstanceIfPossible(Application application, ActivityTracker tracker) {
            if (Build.VERSION.SDK_INT >= 14) {
                return new AutomaticTrackerICSAndBeyond(application, tracker);
            }
            return null;
        }

        public abstract void register();

        public abstract void unregister();

        @TargetApi(value=14)
        private static class AutomaticTrackerICSAndBeyond
        extends AutomaticTracker {
            private final Application mApplication;
            private final ActivityTracker mTracker;
            private final Application.ActivityLifecycleCallbacks mLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    AutomaticTrackerICSAndBeyond.this.mTracker.add(activity);
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                    AutomaticTrackerICSAndBeyond.this.mTracker.remove(activity);
                }
            };

            public AutomaticTrackerICSAndBeyond(Application application, ActivityTracker tracker) {
                this.mApplication = application;
                this.mTracker = tracker;
            }

            @Override
            public void register() {
                this.mApplication.registerActivityLifecycleCallbacks(this.mLifecycleCallbacks);
            }

            @Override
            public void unregister() {
                this.mApplication.unregisterActivityLifecycleCallbacks(this.mLifecycleCallbacks);
            }
        }
    }

    public static interface Listener {
        public void onActivityAdded(Activity var1);

        public void onActivityRemoved(Activity var1);
    }
}

