/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements.android;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.StringUtil;
import com.facebook.stetho.common.android.FragmentActivityAccessor;
import com.facebook.stetho.common.android.FragmentCompat;
import com.facebook.stetho.common.android.FragmentManagerAccessor;
import com.facebook.stetho.inspector.elements.AbstractChainedDescriptor;
import com.facebook.stetho.inspector.elements.Descriptor;
import com.facebook.stetho.inspector.elements.android.AndroidDescriptorHost;
import com.facebook.stetho.inspector.elements.android.HighlightableDescriptor;
import java.util.List;
import javax.annotation.Nullable;

final class ActivityDescriptor
extends AbstractChainedDescriptor<Activity>
implements HighlightableDescriptor {
    ActivityDescriptor() {
    }

    @Override
    protected String onGetNodeName(Activity element) {
        String className = element.getClass().getName();
        return StringUtil.removePrefix(className, "android.app.");
    }

    @Override
    protected void onGetChildren(Activity element, Accumulator<Object> children) {
        ActivityDescriptor.getDialogFragments(FragmentCompat.getSupportLibInstance(), element, children);
        ActivityDescriptor.getDialogFragments(FragmentCompat.getFrameworkInstance(), element, children);
        Window window = element.getWindow();
        if (window != null) {
            children.store(window);
        }
    }

    @Override
    public View getViewForHighlighting(Object element) {
        Descriptor.Host host = this.getHost();
        if (host instanceof AndroidDescriptorHost) {
            Activity activity = (Activity)element;
            Window window = activity.getWindow();
            return ((AndroidDescriptorHost)host).getHighlightingView(window);
        }
        return null;
    }

    private static void getDialogFragments(@Nullable FragmentCompat compat, Activity activity, Accumulator<Object> accumulator) {
        if (compat == null || !compat.getFragmentActivityClass().isInstance(activity)) {
            return;
        }
        FragmentActivityAccessor activityAccessor = compat.forFragmentActivity();
        Object fragmentManager = activityAccessor.getFragmentManager(activity);
        if (fragmentManager == null) {
            return;
        }
        FragmentManagerAccessor fragmentManagerAccessor = compat.forFragmentManager();
        List addedFragments = fragmentManagerAccessor.getAddedFragments(fragmentManager);
        if (addedFragments == null) {
            return;
        }
        int N = addedFragments.size();
        for (int i = 0; i < N; ++i) {
            Object fragment = addedFragments.get(i);
            if (!compat.getDialogFragmentClass().isInstance(fragment)) continue;
            accumulator.store(fragment);
        }
    }
}

