/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements;

import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.ListUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.elements.DocumentView;
import com.facebook.stetho.inspector.elements.ElementInfo;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ShadowDocument
implements DocumentView {
    private final Object mRootElement;
    private final IdentityHashMap<Object, ElementInfo> mElementToInfoMap = new IdentityHashMap();
    private boolean mIsUpdating;

    public ShadowDocument(Object rootElement) {
        this.mRootElement = Util.throwIfNull(rootElement);
    }

    @Override
    public Object getRootElement() {
        return this.mRootElement;
    }

    @Override
    public ElementInfo getElementInfo(Object element) {
        return this.mElementToInfoMap.get(element);
    }

    public UpdateBuilder beginUpdate() {
        if (this.mIsUpdating) {
            throw new IllegalStateException();
        }
        this.mIsUpdating = true;
        return new UpdateBuilder();
    }

    public final class Update
    implements DocumentView {
        private final Map<Object, ElementInfo> mElementToInfoChangesMap;
        private final Set<Object> mRootElementChangesSet;

        public Update(Map<Object, ElementInfo> elementToInfoChangesMap, Set<Object> rootElementChangesSet) {
            this.mElementToInfoChangesMap = elementToInfoChangesMap;
            this.mRootElementChangesSet = rootElementChangesSet;
        }

        public boolean isEmpty() {
            return this.mElementToInfoChangesMap.isEmpty();
        }

        public boolean isElementChanged(Object element) {
            return this.mElementToInfoChangesMap.containsKey(element);
        }

        @Override
        public Object getRootElement() {
            return ShadowDocument.this.getRootElement();
        }

        @Override
        public ElementInfo getElementInfo(Object element) {
            ElementInfo elementInfo = this.mElementToInfoChangesMap.get(element);
            if (elementInfo != null) {
                return elementInfo;
            }
            return (ElementInfo)ShadowDocument.this.mElementToInfoMap.get(element);
        }

        public void getChangedElements(Accumulator<Object> accumulator) {
            for (Object element : this.mElementToInfoChangesMap.keySet()) {
                accumulator.store(element);
            }
        }

        public void getGarbageElements(Accumulator<Object> accumulator) {
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            for (Object element : this.mRootElementChangesSet) {
                ElementInfo newElementInfo = this.getElementInfo(element);
                if (element == ShadowDocument.this.mRootElement || newElementInfo.parentElement != null) continue;
                queue.add(element);
                queue.add(element);
            }
            while (!queue.isEmpty()) {
                Object expectedParent0;
                Object element = queue.remove();
                Object expectedParent = element == (expectedParent0 = queue.remove()) ? null : expectedParent0;
                ElementInfo newElementInfo = this.getElementInfo(element);
                if (newElementInfo.parentElement != expectedParent) continue;
                accumulator.store(element);
                ElementInfo oldElementInfo = ShadowDocument.this.getElementInfo(element);
                if (oldElementInfo == null) continue;
                int N = oldElementInfo.children.size();
                for (int i = 0; i < N; ++i) {
                    queue.add(oldElementInfo.children.get(i));
                    queue.add(element);
                }
            }
        }

        public void abandon() {
            if (!ShadowDocument.this.mIsUpdating) {
                throw new IllegalStateException();
            }
            ShadowDocument.this.mIsUpdating = false;
        }

        public void commit() {
            if (!ShadowDocument.this.mIsUpdating) {
                throw new IllegalStateException();
            }
            ShadowDocument.this.mElementToInfoMap.putAll(this.mElementToInfoChangesMap);
            for (Object element : this.mRootElementChangesSet) {
                this.removeSubTree(ShadowDocument.this.mElementToInfoMap, element);
            }
            ShadowDocument.this.mIsUpdating = false;
        }

        private void removeSubTree(Map<Object, ElementInfo> elementToInfoMap, Object element) {
            ElementInfo elementInfo = elementToInfoMap.get(element);
            elementToInfoMap.remove(element);
            int N = elementInfo.children.size();
            for (int i = 0; i < N; ++i) {
                this.removeSubTree(elementToInfoMap, elementInfo.children.get(i));
            }
        }
    }

    public final class UpdateBuilder {
        private final Map<Object, ElementInfo> mElementToInfoChangesMap = new LinkedHashMap<Object, ElementInfo>();
        private final HashSet<Object> mRootElementChanges = new HashSet();
        private HashSet<Object> mCachedNotNewChildrenSet;

        public void setElementChildren(Object element, List<Object> children) {
            Object childElement;
            int i;
            int N;
            ElementInfo newElementInfo;
            ElementInfo changesElementInfo = this.mElementToInfoChangesMap.get(element);
            if (changesElementInfo != null && ListUtil.identityEquals(children, changesElementInfo.children)) {
                return;
            }
            ElementInfo oldElementInfo = (ElementInfo)ShadowDocument.this.mElementToInfoMap.get(element);
            if (changesElementInfo == null && oldElementInfo != null && ListUtil.identityEquals(children, oldElementInfo.children)) {
                return;
            }
            if (changesElementInfo != null && oldElementInfo != null && oldElementInfo.parentElement == changesElementInfo.parentElement && ListUtil.identityEquals(children, oldElementInfo.children)) {
                newElementInfo = (ElementInfo)ShadowDocument.this.mElementToInfoMap.get(element);
                this.mElementToInfoChangesMap.remove(element);
            } else {
                Object parentElement = changesElementInfo != null ? changesElementInfo.parentElement : (oldElementInfo != null ? oldElementInfo.parentElement : null);
                newElementInfo = new ElementInfo(element, parentElement, children);
                this.mElementToInfoChangesMap.put(element, newElementInfo);
            }
            HashSet<Object> notNewChildrenSet = this.acquireNotNewChildrenHashSet();
            if (oldElementInfo != null && oldElementInfo.children != newElementInfo.children) {
                N = oldElementInfo.children.size();
                for (i = 0; i < N; ++i) {
                    childElement = oldElementInfo.children.get(i);
                    notNewChildrenSet.add(childElement);
                }
            }
            if (changesElementInfo != null && changesElementInfo.children != newElementInfo.children) {
                N = changesElementInfo.children.size();
                for (i = 0; i < N; ++i) {
                    childElement = changesElementInfo.children.get(i);
                    notNewChildrenSet.add(childElement);
                }
            }
            N = newElementInfo.children.size();
            for (i = 0; i < N; ++i) {
                childElement = newElementInfo.children.get(i);
                this.setElementParent(childElement, element);
                notNewChildrenSet.remove(childElement);
            }
            for (Object childElement2 : notNewChildrenSet) {
                ElementInfo oldChangesElementInfo;
                ElementInfo childChangesElementInfo = this.mElementToInfoChangesMap.get(childElement2);
                if (childChangesElementInfo != null && childChangesElementInfo.parentElement != element || (oldChangesElementInfo = (ElementInfo)ShadowDocument.this.mElementToInfoMap.get(childElement2)) == null || oldChangesElementInfo.parentElement != element) continue;
                this.setElementParent(childElement2, null);
            }
            this.releaseNotNewChildrenHashSet(notNewChildrenSet);
        }

        private void setElementParent(Object element, Object parentElement) {
            ElementInfo changesElementInfo = this.mElementToInfoChangesMap.get(element);
            if (changesElementInfo != null && parentElement == changesElementInfo.parentElement) {
                return;
            }
            ElementInfo oldElementInfo = (ElementInfo)ShadowDocument.this.mElementToInfoMap.get(element);
            if (changesElementInfo == null && oldElementInfo != null && parentElement == oldElementInfo.parentElement) {
                return;
            }
            if (changesElementInfo != null && oldElementInfo != null && parentElement == oldElementInfo.parentElement && ListUtil.identityEquals(oldElementInfo.children, changesElementInfo.children)) {
                this.mElementToInfoChangesMap.remove(element);
                if (parentElement == null) {
                    this.mRootElementChanges.remove(element);
                }
                return;
            }
            List<Object> children = changesElementInfo != null ? changesElementInfo.children : (oldElementInfo != null ? oldElementInfo.children : Collections.emptyList());
            ElementInfo newElementInfo = new ElementInfo(element, parentElement, children);
            this.mElementToInfoChangesMap.put(element, newElementInfo);
            if (parentElement == null) {
                this.mRootElementChanges.add(element);
            }
        }

        public Update build() {
            return new Update(this.mElementToInfoChangesMap, this.mRootElementChanges);
        }

        private HashSet<Object> acquireNotNewChildrenHashSet() {
            HashSet<Object> notNewChildrenHashSet = this.mCachedNotNewChildrenSet;
            if (notNewChildrenHashSet == null) {
                notNewChildrenHashSet = new HashSet();
            }
            this.mCachedNotNewChildrenSet = null;
            return notNewChildrenHashSet;
        }

        private void releaseNotNewChildrenHashSet(HashSet<Object> notNewChildrenHashSet) {
            notNewChildrenHashSet.clear();
            if (this.mCachedNotNewChildrenSet == null) {
                this.mCachedNotNewChildrenSet = notNewChildrenHashSet;
            }
        }
    }
}

