/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements;

import android.os.SystemClock;
import com.facebook.stetho.common.Accumulator;
import com.facebook.stetho.common.ArrayListAccumulator;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.elements.AttributeAccumulator;
import com.facebook.stetho.inspector.elements.DocumentProvider;
import com.facebook.stetho.inspector.elements.DocumentProviderFactory;
import com.facebook.stetho.inspector.elements.DocumentProviderListener;
import com.facebook.stetho.inspector.elements.DocumentView;
import com.facebook.stetho.inspector.elements.ElementInfo;
import com.facebook.stetho.inspector.elements.NodeDescriptor;
import com.facebook.stetho.inspector.elements.ShadowDocument;
import com.facebook.stetho.inspector.elements.StyleAccumulator;
import com.facebook.stetho.inspector.helper.ObjectIdMapper;
import com.facebook.stetho.inspector.helper.ThreadBoundProxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class Document
extends ThreadBoundProxy {
    private final DocumentProviderFactory mFactory;
    private final ObjectIdMapper mObjectIdMapper;
    private final Queue<Object> mCachedUpdateQueue;
    private DocumentProvider mDocumentProvider;
    private ShadowDocument mShadowDocument;
    private UpdateListenerCollection mUpdateListeners;
    private ChildEventingList mCachedChildEventingList;
    private ArrayListAccumulator<Object> mCachedChildrenAccumulator;
    private AttributeListAccumulator mCachedAttributeAccumulator;
    @GuardedBy(value="this")
    private int mReferenceCounter;

    public Document(DocumentProviderFactory factory) {
        super(factory);
        this.mFactory = factory;
        this.mObjectIdMapper = new DocumentObjectIdMapper();
        this.mReferenceCounter = 0;
        this.mUpdateListeners = new UpdateListenerCollection();
        this.mCachedUpdateQueue = new ArrayDeque<Object>();
    }

    public synchronized void addRef() {
        if (this.mReferenceCounter++ == 0) {
            this.init();
        }
    }

    public synchronized void release() {
        if (this.mReferenceCounter > 0 && --this.mReferenceCounter == 0) {
            this.cleanUp();
        }
    }

    private void init() {
        this.mDocumentProvider = this.mFactory.create();
        this.mDocumentProvider.postAndWait(new Runnable(){

            @Override
            public void run() {
                Document.this.mShadowDocument = new ShadowDocument(Document.this.mDocumentProvider.getRootElement());
                Document.this.createShadowDocumentUpdate().commit();
                Document.this.mDocumentProvider.setListener(new ProviderListener());
            }
        });
    }

    private void cleanUp() {
        this.mDocumentProvider.postAndWait(new Runnable(){

            @Override
            public void run() {
                Document.this.mDocumentProvider.setListener(null);
                Document.this.mShadowDocument = null;
                Document.this.mObjectIdMapper.clear();
                Document.this.mDocumentProvider.dispose();
                Document.this.mDocumentProvider = null;
            }
        });
        this.mUpdateListeners.clear();
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.mUpdateListeners.add(updateListener);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.mUpdateListeners.remove(updateListener);
    }

    @Nullable
    public NodeDescriptor getNodeDescriptor(Object element) {
        this.verifyThreadAccess();
        return this.mDocumentProvider.getNodeDescriptor(element);
    }

    public void highlightElement(Object element, int color2) {
        this.verifyThreadAccess();
        this.mDocumentProvider.highlightElement(element, color2);
    }

    public void hideHighlight() {
        this.verifyThreadAccess();
        this.mDocumentProvider.hideHighlight();
    }

    public void setInspectModeEnabled(boolean enabled) {
        this.verifyThreadAccess();
        this.mDocumentProvider.setInspectModeEnabled(enabled);
    }

    @Nullable
    public Integer getNodeIdForElement(Object element) {
        return this.mObjectIdMapper.getIdForObject(element);
    }

    @Nullable
    public Object getElementForNodeId(int id2) {
        return this.mObjectIdMapper.getObjectForId(id2);
    }

    public void setAttributesAsText(Object element, String text) {
        this.verifyThreadAccess();
        this.mDocumentProvider.setAttributesAsText(element, text);
    }

    public void getElementStyles(Object element, StyleAccumulator styleAccumulator) {
        NodeDescriptor nodeDescriptor = this.getNodeDescriptor(element);
        nodeDescriptor.getStyles(element, styleAccumulator);
    }

    public DocumentView getDocumentView() {
        this.verifyThreadAccess();
        return this.mShadowDocument;
    }

    public Object getRootElement() {
        this.verifyThreadAccess();
        Object rootElement = this.mDocumentProvider.getRootElement();
        if (rootElement == null) {
            throw new IllegalStateException();
        }
        if (rootElement != this.mShadowDocument.getRootElement()) {
            throw new IllegalStateException();
        }
        return rootElement;
    }

    public void findMatchingElements(String query, Accumulator<Integer> matchedIds) {
        this.verifyThreadAccess();
        Pattern queryPattern = Pattern.compile(Pattern.quote(query), 2);
        Object rootElement = this.mDocumentProvider.getRootElement();
        this.findMatches(rootElement, queryPattern, matchedIds);
    }

    private void findMatches(Object element, Pattern queryPattern, Accumulator<Integer> matchedIds) {
        ElementInfo info = this.mShadowDocument.getElementInfo(element);
        int size = info.children.size();
        for (int i = 0; i < size; ++i) {
            Object childElement = info.children.get(i);
            if (this.doesElementMatch(childElement, queryPattern)) {
                matchedIds.store(this.mObjectIdMapper.getIdForObject(childElement));
            }
            this.findMatches(childElement, queryPattern, matchedIds);
        }
    }

    private boolean doesElementMatch(Object element, Pattern queryPattern) {
        AttributeListAccumulator accumulator = this.acquireCachedAttributeAccumulator();
        NodeDescriptor descriptor = this.mDocumentProvider.getNodeDescriptor(element);
        descriptor.getAttributes(element, accumulator);
        int N = accumulator.size();
        for (int i = 0; i < N; ++i) {
            if (!queryPattern.matcher((CharSequence)accumulator.get(i)).find()) continue;
            this.releaseCachedAttributeAccumulator(accumulator);
            return true;
        }
        this.releaseCachedAttributeAccumulator(accumulator);
        return queryPattern.matcher(descriptor.getNodeName(element)).find();
    }

    private ChildEventingList acquireChildEventingList(Object parentElement, DocumentView documentView) {
        ChildEventingList childEventingList = this.mCachedChildEventingList;
        if (childEventingList == null) {
            childEventingList = new ChildEventingList();
        }
        this.mCachedChildEventingList = null;
        childEventingList.acquire(parentElement, documentView);
        return childEventingList;
    }

    private void releaseChildEventingList(ChildEventingList childEventingList) {
        childEventingList.release();
        if (this.mCachedChildEventingList == null) {
            this.mCachedChildEventingList = childEventingList;
        }
    }

    private AttributeListAccumulator acquireCachedAttributeAccumulator() {
        AttributeListAccumulator accumulator = this.mCachedAttributeAccumulator;
        if (accumulator == null) {
            accumulator = new AttributeListAccumulator();
        }
        this.mCachedChildrenAccumulator = null;
        return accumulator;
    }

    private void releaseCachedAttributeAccumulator(AttributeListAccumulator accumulator) {
        accumulator.clear();
        if (this.mCachedAttributeAccumulator == null) {
            this.mCachedAttributeAccumulator = accumulator;
        }
    }

    private ArrayListAccumulator<Object> acquireChildrenAccumulator() {
        ArrayListAccumulator<Object> accumulator = this.mCachedChildrenAccumulator;
        if (accumulator == null) {
            accumulator = new ArrayListAccumulator();
        }
        this.mCachedChildrenAccumulator = null;
        return accumulator;
    }

    private void releaseChildrenAccumulator(ArrayListAccumulator<Object> accumulator) {
        accumulator.clear();
        if (this.mCachedChildrenAccumulator == null) {
            this.mCachedChildrenAccumulator = accumulator;
        }
    }

    private ShadowDocument.Update createShadowDocumentUpdate() {
        this.verifyThreadAccess();
        if (this.mDocumentProvider.getRootElement() != this.mShadowDocument.getRootElement()) {
            throw new IllegalStateException();
        }
        ArrayListAccumulator<Object> childrenAccumulator = this.acquireChildrenAccumulator();
        ShadowDocument.UpdateBuilder updateBuilder = this.mShadowDocument.beginUpdate();
        this.mCachedUpdateQueue.add(this.mDocumentProvider.getRootElement());
        while (!this.mCachedUpdateQueue.isEmpty()) {
            Object element = this.mCachedUpdateQueue.remove();
            NodeDescriptor descriptor = this.mDocumentProvider.getNodeDescriptor(element);
            this.mObjectIdMapper.putObject(element);
            descriptor.getChildren(element, childrenAccumulator);
            int size = childrenAccumulator.size();
            for (int i = 0; i < size; ++i) {
                Object child = childrenAccumulator.get(i);
                if (child != null) {
                    this.mCachedUpdateQueue.add(child);
                    continue;
                }
                LogUtil.e("%s.getChildren() emitted a null child at position %s for element %s", descriptor.getClass().getName(), Integer.toString(i), element);
                childrenAccumulator.remove(i);
                --i;
                --size;
            }
            updateBuilder.setElementChildren(element, childrenAccumulator);
            childrenAccumulator.clear();
        }
        this.releaseChildrenAccumulator(childrenAccumulator);
        return updateBuilder.build();
    }

    private void updateTree() {
        long startTimeMs = SystemClock.elapsedRealtime();
        ShadowDocument.Update docUpdate = this.createShadowDocumentUpdate();
        boolean isEmpty = docUpdate.isEmpty();
        if (isEmpty) {
            docUpdate.abandon();
        } else {
            this.applyDocumentUpdate(docUpdate);
        }
        long deltaMs = SystemClock.elapsedRealtime() - startTimeMs;
        LogUtil.d("Document.updateTree() completed in %s ms%s", Long.toString(deltaMs), isEmpty ? " (no changes)" : "");
    }

    private void applyDocumentUpdate(final ShadowDocument.Update docUpdate) {
        docUpdate.getGarbageElements(new Accumulator<Object>(){

            @Override
            public void store(Object element) {
                if (!Document.this.mObjectIdMapper.containsObject(element)) {
                    throw new IllegalStateException();
                }
                ElementInfo newElementInfo = docUpdate.getElementInfo(element);
                if (newElementInfo.parentElement == null) {
                    ElementInfo oldElementInfo = Document.this.mShadowDocument.getElementInfo(element);
                    int parentNodeId = Document.this.mObjectIdMapper.getIdForObject(oldElementInfo.parentElement);
                    int nodeId = Document.this.mObjectIdMapper.getIdForObject(element);
                    Document.this.mUpdateListeners.onChildNodeRemoved(parentNodeId, nodeId);
                }
                Document.this.mObjectIdMapper.removeObject(element);
            }
        });
        docUpdate.getChangedElements(new Accumulator<Object>(){
            private final HashSet<Object> listenerInsertedElements = new HashSet();
            private Accumulator<Object> insertedElements = new Accumulator<Object>(){

                @Override
                public void store(Object element) {
                    if (docUpdate.isElementChanged(element)) {
                        listenerInsertedElements.add(element);
                    }
                }
            };

            @Override
            public void store(Object element) {
                if (!Document.this.mObjectIdMapper.containsObject(element)) {
                    return;
                }
                if (this.listenerInsertedElements.contains(element)) {
                    return;
                }
                ElementInfo newElementInfo = docUpdate.getElementInfo(element);
                ElementInfo oldElementInfo = Document.this.mShadowDocument.getElementInfo(element);
                List<Object> oldChildren = oldElementInfo != null ? oldElementInfo.children : Collections.emptyList();
                List<Object> newChildren = newElementInfo.children;
                ChildEventingList listenerChildren = Document.this.acquireChildEventingList(element, docUpdate);
                int N = oldChildren.size();
                for (int i = 0; i < N; ++i) {
                    Object childElement = oldChildren.get(i);
                    if (!Document.this.mObjectIdMapper.containsObject(childElement)) continue;
                    listenerChildren.add(childElement);
                }
                Document.updateListenerChildren(listenerChildren, newChildren, this.insertedElements);
                Document.this.releaseChildEventingList(listenerChildren);
            }
        });
        docUpdate.commit();
    }

    private static void updateListenerChildren(ChildEventingList listenerChildren, List<Object> newChildren, Accumulator<Object> insertedElements) {
        int index = 0;
        while (index <= listenerChildren.size()) {
            Object newElement;
            if (index == listenerChildren.size()) {
                if (index == newChildren.size()) break;
                Object newElement2 = newChildren.get(index);
                listenerChildren.addWithEvent(index, newElement2, insertedElements);
                ++index;
                continue;
            }
            if (index == newChildren.size()) {
                listenerChildren.removeWithEvent(index);
                continue;
            }
            Object listenerElement = listenerChildren.get(index);
            if (listenerElement == (newElement = newChildren.get(index))) {
                ++index;
                continue;
            }
            int newElementListenerIndex = listenerChildren.indexOf(newElement);
            if (newElementListenerIndex == -1) {
                listenerChildren.addWithEvent(index, newElement, insertedElements);
                ++index;
                continue;
            }
            listenerChildren.removeWithEvent(newElementListenerIndex);
            listenerChildren.addWithEvent(index, newElement, insertedElements);
            ++index;
        }
    }

    public static final class AttributeListAccumulator
    extends ArrayList<String>
    implements AttributeAccumulator {
        @Override
        public void store(String name, String value) {
            this.add(name);
            this.add(value);
        }
    }

    private final class ProviderListener
    implements DocumentProviderListener {
        private ProviderListener() {
        }

        @Override
        public void onPossiblyChanged() {
            Document.this.updateTree();
        }

        @Override
        public void onAttributeModified(Object element, String name, String value) {
            Document.this.verifyThreadAccess();
            Document.this.mUpdateListeners.onAttributeModified(element, name, value);
        }

        @Override
        public void onAttributeRemoved(Object element, String name) {
            Document.this.verifyThreadAccess();
            Document.this.mUpdateListeners.onAttributeRemoved(element, name);
        }

        @Override
        public void onInspectRequested(Object element) {
            Document.this.verifyThreadAccess();
            Document.this.mUpdateListeners.onInspectRequested(element);
        }
    }

    private final class DocumentObjectIdMapper
    extends ObjectIdMapper {
        private DocumentObjectIdMapper() {
        }

        @Override
        protected void onMapped(Object object, int id2) {
            Document.this.verifyThreadAccess();
            NodeDescriptor descriptor = Document.this.mDocumentProvider.getNodeDescriptor(object);
            descriptor.hook(object);
        }

        @Override
        protected void onUnmapped(Object object, int id2) {
            Document.this.verifyThreadAccess();
            NodeDescriptor descriptor = Document.this.mDocumentProvider.getNodeDescriptor(object);
            descriptor.unhook(object);
        }
    }

    public static interface UpdateListener {
        public void onAttributeModified(Object var1, String var2, String var3);

        public void onAttributeRemoved(Object var1, String var2);

        public void onInspectRequested(Object var1);

        public void onChildNodeRemoved(int var1, int var2);

        public void onChildNodeInserted(DocumentView var1, Object var2, int var3, int var4, Accumulator<Object> var5);
    }

    private class UpdateListenerCollection
    implements UpdateListener {
        private final List<UpdateListener> mListeners = new ArrayList<UpdateListener>();
        private volatile UpdateListener[] mListenersSnapshot;

        public synchronized void add(UpdateListener listener) {
            this.mListeners.add(listener);
            this.mListenersSnapshot = null;
        }

        public synchronized void remove(UpdateListener listener) {
            this.mListeners.remove(listener);
            this.mListenersSnapshot = null;
        }

        public synchronized void clear() {
            this.mListeners.clear();
            this.mListenersSnapshot = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UpdateListener[] getListenersSnapshot() {
            UpdateListener[] listenersSnapshot;
            while ((listenersSnapshot = this.mListenersSnapshot) == null) {
                UpdateListenerCollection updateListenerCollection = this;
                synchronized (updateListenerCollection) {
                    if (this.mListenersSnapshot == null) {
                        this.mListenersSnapshot = this.mListeners.toArray(new UpdateListener[this.mListeners.size()]);
                        return this.mListenersSnapshot;
                    }
                }
            }
            return listenersSnapshot;
        }

        @Override
        public void onAttributeModified(Object element, String name, String value) {
            for (UpdateListener listener : this.getListenersSnapshot()) {
                listener.onAttributeModified(element, name, value);
            }
        }

        @Override
        public void onAttributeRemoved(Object element, String name) {
            for (UpdateListener listener : this.getListenersSnapshot()) {
                listener.onAttributeRemoved(element, name);
            }
        }

        @Override
        public void onInspectRequested(Object element) {
            for (UpdateListener listener : this.getListenersSnapshot()) {
                listener.onInspectRequested(element);
            }
        }

        @Override
        public void onChildNodeRemoved(int parentNodeId, int nodeId) {
            for (UpdateListener listener : this.getListenersSnapshot()) {
                listener.onChildNodeRemoved(parentNodeId, nodeId);
            }
        }

        @Override
        public void onChildNodeInserted(DocumentView view, Object element, int parentNodeId, int previousNodeId, Accumulator<Object> insertedItems) {
            for (UpdateListener listener : this.getListenersSnapshot()) {
                listener.onChildNodeInserted(view, element, parentNodeId, previousNodeId, insertedItems);
            }
        }
    }

    private final class ChildEventingList
    extends ArrayList<Object> {
        private Object mParentElement = null;
        private int mParentNodeId = -1;
        private DocumentView mDocumentView;

        private ChildEventingList() {
        }

        public void acquire(Object parentElement, DocumentView documentView) {
            this.mParentElement = parentElement;
            this.mParentNodeId = this.mParentElement == null ? -1 : Document.this.mObjectIdMapper.getIdForObject(this.mParentElement);
            this.mDocumentView = documentView;
        }

        public void release() {
            this.clear();
            this.mParentElement = null;
            this.mParentNodeId = -1;
            this.mDocumentView = null;
        }

        public void addWithEvent(int index, Object element, Accumulator<Object> insertedElements) {
            Object previousElement = index == 0 ? null : this.get(index - 1);
            int previousNodeId = previousElement == null ? -1 : Document.this.mObjectIdMapper.getIdForObject(previousElement);
            this.add(index, element);
            Document.this.mUpdateListeners.onChildNodeInserted(this.mDocumentView, element, this.mParentNodeId, previousNodeId, insertedElements);
        }

        public void removeWithEvent(int index) {
            Object element = this.remove(index);
            int nodeId = Document.this.mObjectIdMapper.getIdForObject(element);
            Document.this.mUpdateListeners.onChildNodeRemoved(this.mParentNodeId, nodeId);
        }
    }
}

