/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.elements;

import com.facebook.stetho.common.ThreadBound;
import com.facebook.stetho.common.UncheckedCallable;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.elements.NodeDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class Descriptor
implements NodeDescriptor {
    private Host mHost;

    protected Descriptor() {
    }

    final void initialize(Host host) {
        Util.throwIfNull(host);
        Util.throwIfNotNull(this.mHost);
        this.mHost = host;
    }

    final boolean isInitialized() {
        return this.mHost != null;
    }

    protected final Host getHost() {
        return this.mHost;
    }

    @Override
    public final boolean checkThreadAccess() {
        return this.getHost().checkThreadAccess();
    }

    @Override
    public final void verifyThreadAccess() {
        this.getHost().verifyThreadAccess();
    }

    @Override
    public final <V> V postAndWait(UncheckedCallable<V> c) {
        return this.getHost().postAndWait(c);
    }

    @Override
    public final void postAndWait(Runnable r) {
        this.getHost().postAndWait(r);
    }

    @Override
    public final void postDelayed(Runnable r, long delayMillis) {
        this.getHost().postDelayed(r, delayMillis);
    }

    @Override
    public final void removeCallbacks(Runnable r) {
        this.getHost().removeCallbacks(r);
    }

    protected static Map<String, String> parseSetAttributesAsTextArg(String text) {
        String value = "";
        String key = "";
        StringBuilder buffer = new StringBuilder();
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        boolean isInsideQuotes = false;
        int N = text.length();
        for (int i = 0; i < N; ++i) {
            char c = text.charAt(i);
            if (c == '=') {
                key = buffer.toString();
                buffer.setLength(0);
                continue;
            }
            if (c == '\"') {
                if (isInsideQuotes) {
                    value = buffer.toString();
                    buffer.setLength(0);
                }
                isInsideQuotes = !isInsideQuotes;
                continue;
            }
            if (c == ' ' && !isInsideQuotes) {
                keyValuePairs.put(key, value);
                continue;
            }
            buffer.append(c);
        }
        if (!key.isEmpty() && !value.isEmpty()) {
            keyValuePairs.put(key, value);
        }
        return keyValuePairs;
    }

    public static interface Host
    extends ThreadBound {
        @Nullable
        public Descriptor getDescriptor(@Nullable Object var1);

        public void onAttributeModified(Object var1, String var2, String var3);

        public void onAttributeRemoved(Object var1, String var2);
    }
}

