/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.domstorage;

import android.content.Context;
import android.content.SharedPreferences;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.domstorage.SharedPreferencesHelper;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeerRegistrationListener;
import com.facebook.stetho.inspector.helper.PeersRegisteredListener;
import com.facebook.stetho.inspector.protocol.module.DOMStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DOMStoragePeerManager
extends ChromePeerManager {
    private final Context mContext;
    private final PeerRegistrationListener mPeerListener = new PeersRegisteredListener(){
        private final List<DevToolsSharedPreferencesListener> mPrefsListeners = new ArrayList<DevToolsSharedPreferencesListener>();

        @Override
        protected synchronized void onFirstPeerRegistered() {
            List<String> tags = SharedPreferencesHelper.getSharedPreferenceTags(DOMStoragePeerManager.this.mContext);
            for (String tag : tags) {
                SharedPreferences prefs = DOMStoragePeerManager.this.mContext.getSharedPreferences(tag, 0);
                DevToolsSharedPreferencesListener listener = new DevToolsSharedPreferencesListener(prefs, tag);
                prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)listener);
                this.mPrefsListeners.add(listener);
            }
        }

        @Override
        protected synchronized void onLastPeerUnregistered() {
            for (DevToolsSharedPreferencesListener prefsListener : this.mPrefsListeners) {
                prefsListener.unregister();
            }
            this.mPrefsListeners.clear();
        }
    };

    public DOMStoragePeerManager(Context context) {
        this.mContext = context;
        this.setListener(this.mPeerListener);
    }

    public void signalItemRemoved(DOMStorage.StorageId storageId, String key) {
        DOMStorage.DomStorageItemRemovedParams params = new DOMStorage.DomStorageItemRemovedParams();
        params.storageId = storageId;
        params.key = key;
        this.sendNotificationToPeers("DOMStorage.domStorageItemRemoved", params);
    }

    public void signalItemAdded(DOMStorage.StorageId storageId, String key, String value) {
        DOMStorage.DomStorageItemAddedParams params = new DOMStorage.DomStorageItemAddedParams();
        params.storageId = storageId;
        params.key = key;
        params.newValue = value;
        this.sendNotificationToPeers("DOMStorage.domStorageItemAdded", params);
    }

    public void signalItemUpdated(DOMStorage.StorageId storageId, String key, String oldValue, String newValue) {
        DOMStorage.DomStorageItemUpdatedParams params = new DOMStorage.DomStorageItemUpdatedParams();
        params.storageId = storageId;
        params.key = key;
        params.oldValue = oldValue;
        params.newValue = newValue;
        this.sendNotificationToPeers("DOMStorage.domStorageItemUpdated", params);
    }

    private static Map<String, Object> prefsCopy(Map<String, ?> src) {
        HashMap<String, Object> dst = new HashMap<String, Object>(src.size());
        for (Map.Entry<String, ?> entry : src.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Set) {
                dst.put(key, DOMStoragePeerManager.shallowCopy((Set)value));
                continue;
            }
            dst.put(key, value);
        }
        return dst;
    }

    private static <T> Set<T> shallowCopy(Set<T> src) {
        HashSet<T> dst = new HashSet<T>();
        for (T item : src) {
            dst.add(item);
        }
        return dst;
    }

    private class DevToolsSharedPreferencesListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private final SharedPreferences mPrefs;
        private final DOMStorage.StorageId mStorageId;
        private final Map<String, Object> mCopy;

        public DevToolsSharedPreferencesListener(SharedPreferences prefs, String tag) {
            this.mPrefs = prefs;
            this.mStorageId = new DOMStorage.StorageId();
            this.mStorageId.securityOrigin = tag;
            this.mStorageId.isLocalStorage = true;
            this.mCopy = DOMStoragePeerManager.prefsCopy(prefs.getAll());
        }

        public void unregister() {
            this.mPrefs.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            Object newValue;
            Map entries = sharedPreferences.getAll();
            boolean existedBefore = this.mCopy.containsKey(key);
            boolean existsNow = entries.containsKey(key);
            Object v = newValue = existsNow ? (Object)entries.get(key) : null;
            if (existedBefore && existsNow) {
                DOMStoragePeerManager.this.signalItemUpdated(this.mStorageId, key, SharedPreferencesHelper.valueToString(this.mCopy.get(key)), SharedPreferencesHelper.valueToString(newValue));
                this.mCopy.put(key, newValue);
            } else if (existedBefore) {
                DOMStoragePeerManager.this.signalItemRemoved(this.mStorageId, key);
                this.mCopy.remove(key);
            } else if (existsNow) {
                DOMStoragePeerManager.this.signalItemAdded(this.mStorageId, key, SharedPreferencesHelper.valueToString(newValue));
                this.mCopy.put(key, newValue);
            } else {
                LogUtil.i("Detected rapid put/remove of %s", key);
            }
        }
    }
}

