/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.database;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.database.DatabaseFilesProvider;
import com.facebook.stetho.inspector.database.DefaultDatabaseFilesProvider;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.helper.PeerRegistrationListener;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.protocol.module.Database;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DatabasePeerManager
extends ChromePeerManager {
    private static final String[] UNINTERESTING_FILENAME_SUFFIXES = new String[]{"-journal", "-shm", "-uid", "-wal"};
    private final Context mContext;
    private final DatabaseFilesProvider mDatabaseFilesProvider;
    private final PeerRegistrationListener mPeerRegistrationListener = new PeerRegistrationListener(){

        @Override
        public void onPeerRegistered(JsonRpcPeer peer) {
            DatabasePeerManager.this.bootstrapNewPeer(peer);
        }

        @Override
        public void onPeerUnregistered(JsonRpcPeer peer) {
        }
    };

    @Deprecated
    public DatabasePeerManager(Context context) {
        this(context, new DefaultDatabaseFilesProvider(context));
    }

    public DatabasePeerManager(Context context, DatabaseFilesProvider databaseFilesProvider) {
        this.mContext = context;
        this.mDatabaseFilesProvider = databaseFilesProvider;
        this.setListener(this.mPeerRegistrationListener);
    }

    private void bootstrapNewPeer(JsonRpcPeer peer) {
        List<File> potentialDatabaseFiles = this.mDatabaseFilesProvider.getDatabaseFiles();
        Collections.sort(potentialDatabaseFiles);
        List<File> tidiedList = DatabasePeerManager.tidyDatabaseList(potentialDatabaseFiles);
        for (File database : tidiedList) {
            Database.DatabaseObject databaseParams = new Database.DatabaseObject();
            databaseParams.id = database.getPath();
            databaseParams.name = database.getName();
            databaseParams.domain = this.mContext.getPackageName();
            databaseParams.version = "N/A";
            Database.AddDatabaseEvent eventParams = new Database.AddDatabaseEvent();
            eventParams.database = databaseParams;
            peer.invokeMethod("Database.addDatabase", eventParams, null);
        }
    }

    static List<File> tidyDatabaseList(List<File> databaseFiles) {
        HashSet<File> originalAsSet = new HashSet<File>(databaseFiles);
        ArrayList<File> tidiedList = new ArrayList<File>();
        for (File databaseFile : databaseFiles) {
            String databaseFilename = databaseFile.getPath();
            String sansSuffix = DatabasePeerManager.removeSuffix(databaseFilename, UNINTERESTING_FILENAME_SUFFIXES);
            if (!sansSuffix.equals(databaseFilename) && originalAsSet.contains(new File(sansSuffix))) continue;
            tidiedList.add(databaseFile);
        }
        return tidiedList;
    }

    private static String removeSuffix(String str, String[] suffixesToRemove) {
        for (String suffix : suffixesToRemove) {
            if (!str.endsWith(suffix)) continue;
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDatabaseTableNames(String databaseName) throws SQLiteException {
        try (SQLiteDatabase database = this.openDatabase(databaseName);){
            ArrayList<String> arrayList;
            Cursor cursor = database.rawQuery("SELECT name FROM sqlite_master WHERE type=?", new String[]{"table"});
            try {
                ArrayList<String> tableNames = new ArrayList<String>();
                while (cursor.moveToNext()) {
                    tableNames.add(cursor.getString(0));
                }
                arrayList = tableNames;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeSQL(String databaseName, String query, ExecuteResultHandler<T> handler) throws SQLiteException {
        Util.throwIfNull(query);
        Util.throwIfNull(handler);
        try (SQLiteDatabase database = this.openDatabase(databaseName);){
            String firstWordUpperCase;
            switch (firstWordUpperCase = DatabasePeerManager.getFirstWord(query).toUpperCase()) {
                case "UPDATE": 
                case "DELETE": {
                    T t = this.executeUpdateDelete(database, query, handler);
                    return t;
                }
                case "INSERT": {
                    T t = this.executeInsert(database, query, handler);
                    return t;
                }
                case "SELECT": 
                case "PRAGMA": 
                case "EXPLAIN": {
                    T t = this.executeSelect(database, query, handler);
                    return t;
                }
            }
            T t = this.executeRawQuery(database, query, handler);
            return t;
        }
    }

    private static String getFirstWord(String s) {
        int firstSpace = (s = s.trim()).indexOf(32);
        return firstSpace >= 0 ? s.substring(0, firstSpace) : s;
    }

    @TargetApi(value=11)
    private <T> T executeUpdateDelete(SQLiteDatabase database, String query, ExecuteResultHandler<T> handler) {
        SQLiteStatement statement = database.compileStatement(query);
        int count = statement.executeUpdateDelete();
        return handler.handleUpdateDelete(count);
    }

    private <T> T executeInsert(SQLiteDatabase database, String query, ExecuteResultHandler<T> handler) {
        SQLiteStatement statement = database.compileStatement(query);
        long count = statement.executeInsert();
        return handler.handleInsert(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeSelect(SQLiteDatabase database, String query, ExecuteResultHandler<T> handler) {
        try (Cursor cursor = database.rawQuery(query, null);){
            T t = handler.handleSelect(cursor);
            return t;
        }
    }

    private <T> T executeRawQuery(SQLiteDatabase database, String query, ExecuteResultHandler<T> handler) {
        database.execSQL(query);
        return handler.handleRawQuery();
    }

    private SQLiteDatabase openDatabase(String databaseName) throws SQLiteException {
        Util.throwIfNull(databaseName);
        File databaseFile = this.mContext.getDatabasePath(databaseName);
        return SQLiteDatabase.openDatabase((String)databaseFile.getAbsolutePath(), null, (int)0);
    }

    public static interface ExecuteResultHandler<T> {
        public T handleRawQuery() throws SQLiteException;

        public T handleSelect(Cursor var1) throws SQLiteException;

        public T handleInsert(long var1) throws SQLiteException;

        public T handleUpdateDelete(int var1) throws SQLiteException;
    }
}

