/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector.console;

import com.facebook.stetho.common.LogRedirector;
import com.facebook.stetho.inspector.console.ConsolePeerManager;
import com.facebook.stetho.inspector.helper.ChromePeerManager;
import com.facebook.stetho.inspector.protocol.module.Console;

public class CLog {
    private static final String TAG = "CLog";

    public static void writeToConsole(ChromePeerManager chromePeerManager, Console.MessageLevel logLevel, Console.MessageSource messageSource, String messageText) {
        LogRedirector.d(TAG, messageText);
        Console.ConsoleMessage message = new Console.ConsoleMessage();
        message.source = messageSource;
        message.level = logLevel;
        message.text = messageText;
        Console.MessageAddedRequest messageAddedRequest = new Console.MessageAddedRequest();
        messageAddedRequest.message = message;
        chromePeerManager.sendNotificationToPeers("Console.messageAdded", messageAddedRequest);
    }

    public static void writeToConsole(Console.MessageLevel logLevel, Console.MessageSource messageSource, String messageText) {
        ConsolePeerManager peerManager = ConsolePeerManager.getInstanceOrNull();
        if (peerManager == null) {
            return;
        }
        CLog.writeToConsole(peerManager, logLevel, messageSource, messageText);
    }
}

