/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector;

import com.facebook.stetho.common.ExceptionUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.jsonrpc.protocol.EmptyResult;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcError;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.json.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.json.JSONException;
import org.json.JSONObject;

@ThreadSafe
public class MethodDispatcher {
    @GuardedBy(value="this")
    private Map<String, MethodDispatchHelper> mMethods;
    private final ObjectMapper mObjectMapper;
    private final Iterable<ChromeDevtoolsDomain> mDomainHandlers;

    public MethodDispatcher(ObjectMapper objectMapper, Iterable<ChromeDevtoolsDomain> domainHandlers) {
        this.mObjectMapper = objectMapper;
        this.mDomainHandlers = domainHandlers;
    }

    private synchronized MethodDispatchHelper findMethodDispatcher(String methodName) {
        if (this.mMethods == null) {
            this.mMethods = MethodDispatcher.buildDispatchTable(this.mObjectMapper, this.mDomainHandlers);
        }
        return this.mMethods.get(methodName);
    }

    public JSONObject dispatch(JsonRpcPeer peer, String methodName, @Nullable JSONObject params) throws JsonRpcException {
        MethodDispatchHelper dispatchHelper = this.findMethodDispatcher(methodName);
        if (dispatchHelper == null) {
            throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.METHOD_NOT_FOUND, "Not implemented: " + methodName, null));
        }
        try {
            return dispatchHelper.invoke(peer, params);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            ExceptionUtil.propagateIfInstanceOf(cause, JsonRpcException.class);
            throw ExceptionUtil.propagate(cause);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new JsonRpcException(new JsonRpcError(JsonRpcError.ErrorCode.INTERNAL_ERROR, e.toString(), null));
        }
    }

    private static Map<String, MethodDispatchHelper> buildDispatchTable(ObjectMapper objectMapper, Iterable<ChromeDevtoolsDomain> domainHandlers) {
        Util.throwIfNull(objectMapper);
        HashMap<String, MethodDispatchHelper> methods = new HashMap<String, MethodDispatchHelper>();
        for (ChromeDevtoolsDomain domainHandler : Util.throwIfNull(domainHandlers)) {
            Class<?> handlerClass = domainHandler.getClass();
            String domainName = handlerClass.getSimpleName();
            for (Method method : handlerClass.getDeclaredMethods()) {
                if (!MethodDispatcher.isDevtoolsMethod(method)) continue;
                MethodDispatchHelper dispatchHelper = new MethodDispatchHelper(objectMapper, domainHandler, method);
                methods.put(domainName + "." + method.getName(), dispatchHelper);
            }
        }
        return Collections.unmodifiableMap(methods);
    }

    private static boolean isDevtoolsMethod(Method method) throws IllegalArgumentException {
        if (!method.isAnnotationPresent(ChromeDevtoolsMethod.class)) {
            return false;
        }
        Class<?>[] args = method.getParameterTypes();
        String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        Util.throwIfNot(args.length == 2, "%s: expected 2 args, got %s", methodName, args.length);
        Util.throwIfNot(args[0].equals(JsonRpcPeer.class), "%s: expected 1st arg of JsonRpcPeer, got %s", methodName, args[0].getName());
        Util.throwIfNot(args[1].equals(JSONObject.class), "%s: expected 2nd arg of JSONObject, got %s", methodName, args[1].getName());
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            Util.throwIfNot(JsonRpcResult.class.isAssignableFrom(returnType), "%s: expected JsonRpcResult return type, got %s", methodName, returnType.getName());
        }
        return true;
    }

    private static class MethodDispatchHelper {
        private final ObjectMapper mObjectMapper;
        private final ChromeDevtoolsDomain mInstance;
        private final Method mMethod;

        public MethodDispatchHelper(ObjectMapper objectMapper, ChromeDevtoolsDomain instance, Method method) {
            this.mObjectMapper = objectMapper;
            this.mInstance = instance;
            this.mMethod = method;
        }

        public JSONObject invoke(JsonRpcPeer peer, @Nullable JSONObject params) throws InvocationTargetException, IllegalAccessException, JSONException, JsonRpcException {
            Object internalResult = this.mMethod.invoke((Object)this.mInstance, peer, params);
            if (internalResult == null || internalResult instanceof EmptyResult) {
                return new JSONObject();
            }
            JsonRpcResult convertableResult = (JsonRpcResult)internalResult;
            return this.mObjectMapper.convertValue(convertableResult, JSONObject.class);
        }
    }
}

