/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.facebook.stetho.common.ProcessUtil;
import com.facebook.stetho.server.SecureHttpRequestHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChromeDiscoveryHandler
extends SecureHttpRequestHandler {
    private static final String PAGE_ID = "1";
    private static final String PATH_PAGE_LIST = "/json";
    private static final String PATH_VERSION = "/json/version";
    private static final String PATH_ACTIVATE = "/json/activate/1";
    private static final String WEBKIT_REV = "@188492";
    private static final String WEBKIT_VERSION = "537.36 (@188492)";
    private static final String USER_AGENT = "Stetho";
    private static final String PROTOCOL_VERSION = "1.1";
    private final Context mContext;
    private final String mInspectorPath;
    @Nullable
    private StringEntity mVersionResponse;
    @Nullable
    private StringEntity mPageListResponse;

    public ChromeDiscoveryHandler(Context context, String inspectorPath) {
        super(context);
        this.mContext = context;
        this.mInspectorPath = inspectorPath;
    }

    public void register(HttpRequestHandlerRegistry registry) {
        registry.register(PATH_PAGE_LIST, (HttpRequestHandler)this);
        registry.register(PATH_VERSION, (HttpRequestHandler)this);
        registry.register("/json/activate/1*", (HttpRequestHandler)this);
    }

    @Override
    protected void handleSecured(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        Uri uri = Uri.parse((String)request.getRequestLine().getUri());
        String path = uri.getPath();
        try {
            if (PATH_VERSION.equals(path)) {
                this.handleVersion(response);
            } else if (PATH_PAGE_LIST.equals(path)) {
                this.handlePageList(response);
            } else if (PATH_ACTIVATE.equals(path)) {
                this.handleActivate(response);
            } else {
                response.setStatusCode(501);
                response.setReasonPhrase("Not Implemented");
                response.setEntity((HttpEntity)new StringEntity("No support for " + uri.getPath()));
            }
        }
        catch (JSONException e) {
            response.setStatusCode(500);
            response.setReasonPhrase("Internal Server Error");
            response.setEntity((HttpEntity)new StringEntity(e.toString(), "UTF-8"));
        }
    }

    private void handleVersion(HttpResponse response) throws JSONException, UnsupportedEncodingException {
        if (this.mVersionResponse == null) {
            JSONObject reply = new JSONObject();
            reply.put("WebKit-Version", (Object)WEBKIT_VERSION);
            reply.put("User-Agent", (Object)USER_AGENT);
            reply.put("Protocol-Version", (Object)PROTOCOL_VERSION);
            reply.put("Browser", (Object)this.getAppLabelAndVersion());
            reply.put("Android-Package", (Object)this.mContext.getPackageName());
            this.mVersionResponse = ChromeDiscoveryHandler.createStringEntity("application/json", reply.toString());
        }
        ChromeDiscoveryHandler.setSuccessfulResponse(response, (HttpEntity)this.mVersionResponse);
    }

    private void handlePageList(HttpResponse response) throws JSONException, UnsupportedEncodingException {
        if (this.mPageListResponse == null) {
            JSONArray reply = new JSONArray();
            JSONObject page = new JSONObject();
            page.put("type", (Object)"app");
            page.put("title", (Object)this.makeTitle());
            page.put("id", (Object)PAGE_ID);
            page.put("description", (Object)"");
            page.put("webSocketDebuggerUrl", (Object)("ws://" + this.mInspectorPath));
            Uri chromeFrontendUrl = new Uri.Builder().scheme("http").authority("chrome-devtools-frontend.appspot.com").appendEncodedPath("serve_rev").appendEncodedPath(WEBKIT_REV).appendEncodedPath("devtools.html").appendQueryParameter("ws", this.mInspectorPath).build();
            page.put("devtoolsFrontendUrl", (Object)chromeFrontendUrl.toString());
            reply.put((Object)page);
            this.mPageListResponse = ChromeDiscoveryHandler.createStringEntity("application/json", reply.toString());
        }
        ChromeDiscoveryHandler.setSuccessfulResponse(response, (HttpEntity)this.mPageListResponse);
    }

    private String makeTitle() {
        StringBuilder b = new StringBuilder();
        b.append(this.getAppLabel());
        b.append(" (powered by Stetho)");
        String processName = ProcessUtil.getProcessName();
        int colonIndex = processName.indexOf(58);
        if (colonIndex >= 0) {
            String nonDefaultProcessName = processName.substring(colonIndex);
            b.append(nonDefaultProcessName);
        }
        return b.toString();
    }

    private void handleActivate(HttpResponse response) throws UnsupportedEncodingException {
        ChromeDiscoveryHandler.setSuccessfulResponse(response, (HttpEntity)ChromeDiscoveryHandler.createStringEntity("text/plain", "Target activation ignored"));
    }

    private static StringEntity createStringEntity(String contentType, String responseJson) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(responseJson, "UTF-8");
        entity.setContentType(contentType);
        return entity;
    }

    private static void setSuccessfulResponse(HttpResponse response, HttpEntity entity) {
        response.setStatusCode(200);
        response.setReasonPhrase("OK");
        response.setEntity(entity);
    }

    private String getAppLabelAndVersion() {
        StringBuilder b = new StringBuilder();
        PackageManager pm = this.mContext.getPackageManager();
        b.append(this.getAppLabel());
        b.append('/');
        try {
            PackageInfo info = pm.getPackageInfo(this.mContext.getPackageName(), 0);
            b.append(info.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        return b.toString();
    }

    private CharSequence getAppLabel() {
        PackageManager pm = this.mContext.getPackageManager();
        return pm.getApplicationLabel(this.mContext.getApplicationInfo());
    }
}

