/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.inspector;

import com.facebook.stetho.common.LogRedirector;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.inspector.MessageHandlingException;
import com.facebook.stetho.inspector.MethodDispatcher;
import com.facebook.stetho.inspector.MismatchedResponseException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.PendingRequest;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcError;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcRequest;
import com.facebook.stetho.inspector.jsonrpc.protocol.JsonRpcResponse;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.websocket.SimpleEndpoint;
import com.facebook.stetho.websocket.SimpleSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ChromeDevtoolsServer
implements SimpleEndpoint {
    private static final String TAG = "ChromeDevtoolsServer";
    public static final String PATH = "/inspector";
    private final ObjectMapper mObjectMapper;
    private final MethodDispatcher mMethodDispatcher;
    private final Map<SimpleSession, JsonRpcPeer> mPeers = Collections.synchronizedMap(new HashMap());

    public ChromeDevtoolsServer(Iterable<ChromeDevtoolsDomain> domainModules) {
        this.mObjectMapper = new ObjectMapper();
        this.mMethodDispatcher = new MethodDispatcher(this.mObjectMapper, domainModules);
    }

    @Override
    public void onOpen(SimpleSession session) {
        LogRedirector.d(TAG, "onOpen");
        this.mPeers.put(session, new JsonRpcPeer(this.mObjectMapper, session));
    }

    @Override
    public void onClose(SimpleSession session, int code, String reasonPhrase) {
        LogRedirector.d(TAG, "onClose: reason=" + code + " " + reasonPhrase);
        JsonRpcPeer peer = this.mPeers.remove(session);
        if (peer != null) {
            peer.invokeDisconnectReceivers();
        }
    }

    @Override
    public void onMessage(SimpleSession session, byte[] message, int messageLen) {
        LogRedirector.d(TAG, "Ignoring binary message of length " + messageLen);
    }

    @Override
    public void onMessage(SimpleSession session, String message) {
        if (LogRedirector.isLoggable(TAG, 2)) {
            LogRedirector.v(TAG, "onMessage: message=" + message);
        }
        try {
            JsonRpcPeer peer = this.mPeers.get(session);
            Util.throwIfNull(peer);
            this.handleRemoteMessage(peer, message);
        }
        catch (IOException e) {
            if (LogRedirector.isLoggable(TAG, 2)) {
                LogRedirector.v(TAG, "Unexpected I/O exception processing message: " + e);
            }
            this.closeSafely(session, 1011, e.getClass().getSimpleName());
        }
        catch (MessageHandlingException e) {
            LogRedirector.i(TAG, "Message could not be processed by implementation: " + e);
            this.closeSafely(session, 1011, e.getClass().getSimpleName());
        }
        catch (JSONException e) {
            LogRedirector.v(TAG, "Unexpected JSON exception processing message", e);
            this.closeSafely(session, 1011, ((Object)((Object)e)).getClass().getSimpleName());
        }
    }

    private void closeSafely(SimpleSession session, int code, String reasonPhrase) {
        session.close(code, reasonPhrase);
    }

    private void handleRemoteMessage(JsonRpcPeer peer, String message) throws IOException, MessageHandlingException, JSONException {
        JSONObject messageNode = new JSONObject(message);
        if (messageNode.has("method")) {
            this.handleRemoteRequest(peer, messageNode);
        } else if (messageNode.has("result")) {
            this.handleRemoteResponse(peer, messageNode);
        } else {
            throw new MessageHandlingException("Improper JSON-RPC message: " + message);
        }
    }

    private void handleRemoteRequest(JsonRpcPeer peer, JSONObject requestNode) throws MessageHandlingException {
        JsonRpcRequest request = this.mObjectMapper.convertValue(requestNode, JsonRpcRequest.class);
        JSONObject result = null;
        JSONObject error = null;
        try {
            result = this.mMethodDispatcher.dispatch(peer, request.method, request.params);
        }
        catch (JsonRpcException e) {
            ChromeDevtoolsServer.logDispatchException(e);
            error = this.mObjectMapper.convertValue(e.getErrorMessage(), JSONObject.class);
        }
        if (request.id != null) {
            String responseString;
            JsonRpcResponse response = new JsonRpcResponse();
            response.id = request.id;
            response.result = result;
            response.error = error;
            JSONObject jsonObject = this.mObjectMapper.convertValue(response, JSONObject.class);
            try {
                responseString = jsonObject.toString();
            }
            catch (OutOfMemoryError e) {
                response.result = null;
                response.error = this.mObjectMapper.convertValue(e.getMessage(), JSONObject.class);
                jsonObject = this.mObjectMapper.convertValue(response, JSONObject.class);
                responseString = jsonObject.toString();
            }
            peer.getWebSocket().sendText(responseString);
        }
    }

    private static void logDispatchException(JsonRpcException e) {
        JsonRpcError errorMessage = e.getErrorMessage();
        switch (errorMessage.code) {
            case METHOD_NOT_FOUND: {
                LogRedirector.d(TAG, "Method not implemented: " + errorMessage.message);
                break;
            }
            default: {
                LogRedirector.w(TAG, "Error processing remote message", e);
            }
        }
    }

    private void handleRemoteResponse(JsonRpcPeer peer, JSONObject responseNode) throws MismatchedResponseException {
        JsonRpcResponse response = this.mObjectMapper.convertValue(responseNode, JsonRpcResponse.class);
        PendingRequest pendingRequest = peer.getAndRemovePendingRequest(response.id);
        if (pendingRequest == null) {
            throw new MismatchedResponseException(response.id);
        }
        if (pendingRequest.callback != null) {
            pendingRequest.callback.onResponse(peer, response);
        }
    }

    @Override
    public void onError(SimpleSession session, Throwable ex) {
        LogRedirector.e(TAG, "onError: ex=" + ex.toString());
    }
}

