/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp.plugins;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharedPreferencesDumperPlugin
implements DumperPlugin {
    private static final String XML_SUFFIX = ".xml";
    private static final String NAME = "prefs";
    private final Context mAppContext;

    public SharedPreferencesDumperPlugin(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void dump(DumperContext dumpContext) throws DumpUsageException {
        String commandName;
        PrintStream writer = dumpContext.getStdout();
        List<String> args = dumpContext.getArgsAsList();
        String string2 = commandName = args.isEmpty() ? "" : args.remove(0);
        if (commandName.equals("print")) {
            this.doPrint(writer, args);
        } else if (commandName.equals("write")) {
            this.doWrite(args);
        } else {
            this.doUsage(writer);
        }
    }

    private void doWrite(List<String> args) throws DumpUsageException {
        String usagePrefix = "Usage: prefs write <path> <key> <type> <value>, where type is one of: ";
        Iterator<String> argsIter = args.iterator();
        String path = SharedPreferencesDumperPlugin.nextArg(argsIter, "Expected <path>");
        String key = SharedPreferencesDumperPlugin.nextArg(argsIter, "Expected <key>");
        String typeName = SharedPreferencesDumperPlugin.nextArg(argsIter, "Expected <type>");
        Type type = Type.of(typeName);
        if (type == null) {
            throw new DumpUsageException(Type.appendNamesList(new StringBuilder(usagePrefix), ", ").toString());
        }
        SharedPreferences sharedPreferences = this.getSharedPreferences(path);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        switch (type) {
            case BOOLEAN: {
                editor.putBoolean(key, Boolean.valueOf(SharedPreferencesDumperPlugin.nextArgValue(argsIter)).booleanValue());
                break;
            }
            case INT: {
                editor.putInt(key, Integer.valueOf(SharedPreferencesDumperPlugin.nextArgValue(argsIter)).intValue());
                break;
            }
            case LONG: {
                editor.putLong(key, Long.valueOf(SharedPreferencesDumperPlugin.nextArgValue(argsIter)).longValue());
                break;
            }
            case FLOAT: {
                editor.putFloat(key, Float.valueOf(SharedPreferencesDumperPlugin.nextArgValue(argsIter)).floatValue());
                break;
            }
            case STRING: {
                editor.putString(key, SharedPreferencesDumperPlugin.nextArgValue(argsIter));
                break;
            }
            case SET: {
                SharedPreferencesDumperPlugin.putStringSet(editor, key, argsIter);
            }
        }
        editor.commit();
    }

    @Nonnull
    private static String nextArg(Iterator<String> iter, String messageIfNotPresent) throws DumpUsageException {
        if (!iter.hasNext()) {
            throw new DumpUsageException(messageIfNotPresent);
        }
        return iter.next();
    }

    @Nonnull
    private static String nextArgValue(Iterator<String> iter) throws DumpUsageException {
        return SharedPreferencesDumperPlugin.nextArg(iter, "Expected <value>");
    }

    @TargetApi(value=11)
    private static void putStringSet(SharedPreferences.Editor editor, String key, Iterator<String> remainingArgs) {
        HashSet<String> set = new HashSet<String>();
        while (remainingArgs.hasNext()) {
            set.add(remainingArgs.next());
        }
        editor.putStringSet(key, set);
    }

    private void doPrint(PrintStream writer, List<String> args) {
        String rootPath = this.mAppContext.getApplicationInfo().dataDir + "/shared_prefs";
        String offsetPrefix = args.isEmpty() ? "" : args.get(0);
        String keyPrefix = args.size() > 1 ? args.get(1) : "";
        this.printRecursive(writer, rootPath, "", offsetPrefix, keyPrefix);
    }

    private void printRecursive(PrintStream writer, String rootPath, String offsetPath, String pathPrefix, String keyPrefix) {
        String[] children;
        File file = new File(rootPath, offsetPath);
        if (file.isFile()) {
            if (offsetPath.endsWith(XML_SUFFIX)) {
                int suffixLength = XML_SUFFIX.length();
                String prefsName = offsetPath.substring(0, offsetPath.length() - suffixLength);
                this.printFile(writer, prefsName, keyPrefix);
            }
        } else if (file.isDirectory() && (children = file.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                String childOffsetPath;
                String string2 = childOffsetPath = TextUtils.isEmpty((CharSequence)offsetPath) ? children[i] : offsetPath + File.separator + children[i];
                if (!childOffsetPath.startsWith(pathPrefix)) continue;
                this.printRecursive(writer, rootPath, childOffsetPath, pathPrefix, keyPrefix);
            }
        }
    }

    private void printFile(PrintStream writer, String prefsName, String keyPrefix) {
        writer.println(prefsName + ":");
        SharedPreferences preferences = this.getSharedPreferences(prefsName);
        for (Map.Entry entry : preferences.getAll().entrySet()) {
            if (!((String)entry.getKey()).startsWith(keyPrefix)) continue;
            writer.println("  " + (String)entry.getKey() + " = " + entry.getValue());
        }
    }

    private void doUsage(PrintStream writer) {
        String cmdName = "dumpapp prefs";
        String usagePrefix = "Usage: dumpapp prefs ";
        String blankPrefix = "       dumpapp prefs ";
        writer.println(usagePrefix + "<command> [command-options]");
        writer.println(usagePrefix + "print [pathPrefix [keyPrefix]]");
        writer.println(Type.appendNamesList(new StringBuilder(blankPrefix).append("write <path> <key> <"), "|").append("> <value>"));
        writer.println();
        writer.println("dumpapp prefs print: Print all matching values from the shared preferences");
        writer.println();
        writer.println("dumpapp prefs write: Writes a value to the shared preferences");
    }

    private SharedPreferences getSharedPreferences(String name) {
        return this.mAppContext.getSharedPreferences(name, 4);
    }

    private static enum Type {
        BOOLEAN("boolean"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        STRING("string"),
        SET("set");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nullable
        public static Type of(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }

        public static StringBuilder appendNamesList(StringBuilder builder, String separator) {
            boolean isFirst = true;
            for (Type type : Type.values()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(separator);
                }
                builder.append(type.name);
            }
            return builder;
        }
    }
}

