/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp.plugins;

import android.content.Context;
import android.os.Debug;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class HprofDumperPlugin
implements DumperPlugin {
    private static final String NAME = "hprof";
    private final Context mContext;

    public HprofDumperPlugin(Context context) {
        this.mContext = context;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void dump(DumperContext dumpContext) throws DumpException {
        String outputPath;
        PrintStream output = dumpContext.getStdout();
        Iterator<String> argsIter = dumpContext.getArgsAsList().iterator();
        String string2 = outputPath = argsIter.hasNext() ? argsIter.next() : null;
        if (outputPath == null) {
            this.usage(output);
        } else if ("-".equals(outputPath)) {
            this.handlePipeOutput(output);
        } else {
            File outputFile = new File(outputPath);
            if (!outputFile.isAbsolute()) {
                outputFile = this.mContext.getFileStreamPath(outputPath);
            }
            this.writeHprof(outputFile);
            output.println("Wrote to " + outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePipeOutput(OutputStream output) throws DumpException {
        File hprofFile = this.mContext.getFileStreamPath("hprof-dump.hprof");
        try {
            this.writeHprof(hprofFile);
            try (FileInputStream input = new FileInputStream(hprofFile);){
                Util.copy(input, output, new byte[2048]);
            }
            catch (IOException e) {
                throw new DumpException("Failure copying " + hprofFile + " to dumper output");
            }
        }
        finally {
            if (hprofFile.exists()) {
                hprofFile.delete();
            }
        }
    }

    private void writeHprof(File outputPath) throws DumpException {
        try {
            HprofDumperPlugin.truncateAndDeleteFile(outputPath);
            Debug.dumpHprofData((String)outputPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new DumpException("Failure writing to " + outputPath + ": " + e.getMessage());
        }
    }

    private static void truncateAndDeleteFile(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.close();
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    private void usage(PrintStream output) throws DumpUsageException {
        output.println("Usage: dumpapp hprof [ path ]");
        output.println("Dump HPROF memory usage data from the running application.");
        output.println();
        output.println("Where path can be any of:");
        output.println("  -           Output directly to stdout");
        output.println("  <path>      Full path to a writable file on the device");
        output.println("  <filename>  Relative filename that will be stored in the app internal storage");
        throw new DumpUsageException("Missing path");
    }
}

