/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp.plugins;

import android.content.Context;
import android.os.Environment;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.dumpapp.ArgsHelper;
import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FilesDumperPlugin
implements DumperPlugin {
    private static final String NAME = "files";
    private final Context mContext;

    public FilesDumperPlugin(Context context) {
        this.mContext = context;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void dump(DumperContext dumpContext) throws DumpException {
        Iterator<String> args = dumpContext.getArgsAsList().iterator();
        String command = ArgsHelper.nextOptionalArg(args, "");
        if ("ls".equals(command)) {
            this.doLs(dumpContext.getStdout());
        } else if ("tree".equals(command)) {
            this.doTree(dumpContext.getStdout());
        } else if ("download".equals(command)) {
            this.doDownload(dumpContext.getStdout(), args);
        } else {
            this.doUsage(dumpContext.getStdout());
            if (!"".equals(command)) {
                throw new DumpUsageException("Unknown command: " + command);
            }
        }
    }

    private void doLs(PrintStream writer) throws DumpUsageException {
        File baseDir = FilesDumperPlugin.getBaseDir(this.mContext);
        if (baseDir.isDirectory()) {
            FilesDumperPlugin.printDirectoryText(baseDir, "", writer);
        }
    }

    private void doTree(PrintStream writer) throws DumpUsageException {
        File baseDir = FilesDumperPlugin.getBaseDir(this.mContext);
        FilesDumperPlugin.printDirectoryVisual(baseDir, 0, writer);
    }

    private static File getBaseDir(Context context) {
        return context.getFilesDir().getParentFile();
    }

    private static void printDirectoryText(File dir, String path, PrintStream writer) {
        File[] listFiles = dir.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (file.isDirectory()) {
                FilesDumperPlugin.printDirectoryText(file, path + file.getName() + "/", writer);
                continue;
            }
            writer.println(path + file.getName());
        }
    }

    private static void printDirectoryVisual(File dir, int depth, PrintStream writer) {
        File[] listFiles = dir.listFiles();
        for (int i = 0; i < listFiles.length; ++i) {
            FilesDumperPlugin.printHeaderVisual(depth, writer);
            File file = listFiles[i];
            writer.print("+---");
            writer.print(file.getName());
            writer.println();
            if (!file.isDirectory()) continue;
            FilesDumperPlugin.printDirectoryVisual(file, depth + 1, writer);
        }
    }

    private static void printHeaderVisual(int depth, PrintStream writer) {
        for (int i = 0; i < depth; ++i) {
            writer.print("|   ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(PrintStream writer, Iterator<String> remainingArgs) throws DumpUsageException {
        String outputPath = ArgsHelper.nextArg(remainingArgs, "Must specify output file or '-'");
        ArrayList<File> selectedFiles = new ArrayList<File>();
        while (remainingArgs.hasNext()) {
            selectedFiles.add(FilesDumperPlugin.resolvePossibleAppStoragePath(this.mContext, remainingArgs.next()));
        }
        try {
            OutputStream outputStream = "-".equals(outputPath) ? writer : new FileOutputStream(FilesDumperPlugin.resolvePossibleSdcardPath(outputPath));
            ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(outputStream));
            boolean success = false;
            try {
                byte[] buf = new byte[2048];
                if (selectedFiles.size() > 0) {
                    this.addFiles(output, buf, selectedFiles.toArray(new File[selectedFiles.size()]));
                } else {
                    this.addFiles(output, buf, FilesDumperPlugin.getBaseDir(this.mContext).listFiles());
                }
                success = true;
            }
            catch (Throwable throwable) {
                block13: {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Util.close(outputStream, !success);
                        if (!success) break block13;
                        throw e;
                    }
                }
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException e) {
                Util.close(outputStream, !success);
                if (success) {
                    throw e;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFiles(ZipOutputStream output, byte[] buf, File[] files) throws IOException {
        for (File file : files) {
            if (file.isDirectory()) {
                this.addFiles(output, buf, file.listFiles());
                continue;
            }
            output.putNextEntry(new ZipEntry(FilesDumperPlugin.relativizePath(FilesDumperPlugin.getBaseDir(this.mContext).getParentFile(), file)));
            try (FileInputStream input = new FileInputStream(file);){
                FilesDumperPlugin.copy(input, output, buf);
            }
        }
    }

    private static void copy(InputStream in, OutputStream out, byte[] buf) throws IOException {
        int n;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
    }

    private static String relativizePath(File base, File path) {
        String baseStr = base.getAbsolutePath();
        String pathStr = path.getAbsolutePath();
        if (pathStr.startsWith(baseStr)) {
            return pathStr.substring(baseStr.length() + 1);
        }
        return pathStr;
    }

    private static File resolvePossibleAppStoragePath(Context context, String path) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        return new File(FilesDumperPlugin.getBaseDir(context), path);
    }

    private static File resolvePossibleSdcardPath(String path) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        return new File(Environment.getExternalStorageDirectory(), path);
    }

    private void doUsage(PrintStream writer) {
        String cmdName = "dumpapp files";
        String usagePrefix = "Usage: dumpapp files ";
        String blankPrefix = "       dumpapp files ";
        writer.println(usagePrefix + "<command> [command-options]");
        writer.println(blankPrefix + "ls");
        writer.println(blankPrefix + "tree");
        writer.println(blankPrefix + "download <output.zip> [<path>...]");
        writer.println();
        writer.println("dumpapp files ls: List files similar to the ls command");
        writer.println();
        writer.println("dumpapp files tree: List files similar to the tree command");
        writer.println();
        writer.println("dumpapp files download: Fetch internal application storage");
        writer.println("    <output.zip>: Output location or '-' for stdout");
        writer.println("    <path>: Fetch only those paths named (directories fetch recursively)");
    }
}

