/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp.plugins;

import com.facebook.stetho.common.ExceptionUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.dumpapp.ArgsHelper;
import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpUsageException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.annotation.Nullable;

public class CrashDumperPlugin
implements DumperPlugin {
    private static final String NAME = "crash";
    private static final String OPTION_THROW_DEFAULT = "java.lang.Error";
    private static final String OPTION_KILL_DEFAULT = "9";
    private static final String OPTION_EXIT_DEFAULT = "0";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void dump(DumperContext dumpContext) throws DumpException {
        Iterator<String> argsIter = dumpContext.getArgsAsList().iterator();
        String command = ArgsHelper.nextOptionalArg(argsIter, null);
        if ("throw".equals(command)) {
            this.doUncaughtException(argsIter);
        } else if ("kill".equals(command)) {
            this.doKill(dumpContext, argsIter);
        } else if ("exit".equals(command)) {
            this.doSystemExit(argsIter);
        } else {
            this.doUsage(dumpContext.getStdout());
            if (command != null) {
                throw new DumpUsageException("Unsupported command: " + command);
            }
        }
    }

    private void doUsage(PrintStream out) {
        String cmdName = "dumpapp crash";
        String usagePrefix = "Usage: dumpapp crash ";
        String blankPrefix = "       dumpapp crash ";
        out.println(usagePrefix + "<command> [command-options]");
        out.println(usagePrefix + "throw");
        out.println(blankPrefix + "kill");
        out.println(blankPrefix + "exit");
        out.println();
        out.println("dumpapp crash throw: Throw an uncaught exception (simulates a program crash)");
        out.println("    <Throwable>: Throwable class to use (default: java.lang.Error)");
        out.println();
        out.println("dumpapp crash kill: Send a signal to this process (simulates the low memory killer)");
        out.println("    <SIGNAL>: Either signal name or number to send (default: 9)");
        out.println("              See `adb shell kill -l` for more information");
        out.println();
        out.println("dumpapp crash exit: Invoke System.exit (simulates an abnormal Android exit strategy)");
        out.println("    <code>: Exit code (default: 0)");
    }

    private void doSystemExit(Iterator<String> argsIter) {
        String exitCodeStr = ArgsHelper.nextOptionalArg(argsIter, OPTION_EXIT_DEFAULT);
        System.exit(Integer.parseInt(exitCodeStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKill(DumperContext dumpContext, Iterator<String> argsIter) throws DumpException {
        String signal = ArgsHelper.nextOptionalArg(argsIter, OPTION_KILL_DEFAULT);
        try {
            Process kill = new ProcessBuilder(new String[0]).command("/system/bin/kill", "-" + signal, String.valueOf(android.os.Process.myPid())).redirectErrorStream(true).start();
            try {
                InputStream in = kill.getInputStream();
                Util.copy(in, dumpContext.getStdout(), new byte[1024]);
            }
            finally {
                kill.destroy();
            }
        }
        catch (IOException e) {
            throw new DumpException("Failed to invoke kill: " + e);
        }
    }

    private void doUncaughtException(Iterator<String> argsIter) throws DumpException {
        String throwableClassString = ArgsHelper.nextOptionalArg(argsIter, OPTION_THROW_DEFAULT);
        try {
            Throwable t;
            Class<?> throwableClass = Class.forName(throwableClassString);
            Constructor<?> ctorWithMessage = CrashDumperPlugin.tryGetDeclaredConstructor(throwableClass, String.class);
            if (ctorWithMessage != null) {
                t = (Throwable)ctorWithMessage.newInstance("Uncaught exception triggered by Stetho");
            } else {
                Constructor<?> ctorParameterless = throwableClass.getDeclaredConstructor(new Class[0]);
                t = (Throwable)ctorParameterless.newInstance(new Object[0]);
            }
            Thread crashThread = new Thread(new ThrowRunnable(t));
            crashThread.start();
            Util.joinUninterruptibly(crashThread);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new DumpException("Invalid supplied Throwable class: " + e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtil.propagate(e.getCause());
        }
    }

    @Nullable
    private static <T> Constructor<? extends T> tryGetDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static class ThrowRunnable
    implements Runnable {
        private final Throwable mThrowable;

        public ThrowRunnable(Throwable t) {
            this.mThrowable = t;
        }

        @Override
        public void run() {
            ExceptionUtil.sneakyThrow(this.mThrowable);
        }
    }
}

