/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp;

import android.content.Context;
import com.facebook.stetho.dumpapp.DumpappHandler;
import com.facebook.stetho.dumpapp.Dumper;
import com.facebook.stetho.dumpapp.StreamFramer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.AbstractHttpEntity;

public class StreamingDumpappHandler
extends DumpappHandler {
    public StreamingDumpappHandler(Context context, Dumper dumper) {
        super(context, dumper);
    }

    @Override
    protected HttpEntity getResponseEntity(HttpRequest request, InputStream bufferedInput, HttpResponse response) throws IOException {
        DumpappHttpEntity entity = new DumpappHttpEntity(request, this.getDumper(), bufferedInput);
        entity.setChunked(true);
        entity.setContentType("application/octet-stream");
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTo(HttpRequest request, Dumper dumper, InputStream input, OutputStream output) throws IOException {
        String[] args = StreamingDumpappHandler.getArgs(request);
        try (StreamFramer framer = new StreamFramer(output);){
            int exitCode = dumper.dump(input, framer.getStdout(), framer.getStderr(), args);
            framer.writeExitCode(exitCode);
        }
    }

    private class DumpappHttpEntity
    extends AbstractHttpEntity {
        private final HttpRequest mRequest;
        private final Dumper mDumper;
        private final InputStream mInput;

        DumpappHttpEntity(HttpRequest request, Dumper dumper, InputStream input) {
            this.mRequest = request;
            this.mDumper = dumper;
            this.mInput = input;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public boolean isStreaming() {
            return true;
        }

        public void writeTo(OutputStream output) throws IOException {
            StreamingDumpappHandler.writeTo(this.mRequest, this.mDumper, this.mInput, output);
        }
    }
}

