/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp;

import com.facebook.stetho.dumpapp.DumpappOutputBrokenException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamFramer
implements Closeable {
    private static final byte STDOUT_FRAME_PREFIX = 49;
    private static final byte STDERR_FRAME_PREFIX = 50;
    private static final byte EXIT_FRAME_PREFIX = 120;
    private final PrintStream mStdout;
    private final PrintStream mStderr;
    private final DataOutputStream mMultiplexedOutputStream;

    public StreamFramer(OutputStream output) throws IOException {
        this.mMultiplexedOutputStream = new DataOutputStream(output);
        this.mStdout = new PrintStream(new BufferedOutputStream(new FramingOutputStream(this.mMultiplexedOutputStream, 49)));
        this.mStderr = new PrintStream(new FramingOutputStream(this.mMultiplexedOutputStream, 50));
    }

    public PrintStream getStdout() {
        return this.mStdout;
    }

    public PrintStream getStderr() {
        return this.mStderr;
    }

    public synchronized void writeExitCode(int exitCode) throws IOException {
        this.mStdout.flush();
        this.mStderr.flush();
        this.writeIntFrame((byte)120, exitCode);
    }

    @Override
    public synchronized void close() throws IOException {
        this.mMultiplexedOutputStream.close();
    }

    private void writeIntFrame(byte type, int intParameter) throws IOException {
        this.mMultiplexedOutputStream.write(type);
        this.mMultiplexedOutputStream.writeInt(intParameter);
    }

    private class FramingOutputStream
    extends OutputStream {
        private final OutputStream mOut;
        private final byte mPrefix;
        private boolean mIsClosed;

        FramingOutputStream(OutputStream innerStream, byte prefix) {
            this.mOut = innerStream;
            this.mPrefix = prefix;
            this.mIsClosed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            if (this.mIsClosed) {
                throw new IOException("Stream is closed");
            }
            if (length > 0) {
                try {
                    StreamFramer streamFramer = StreamFramer.this;
                    synchronized (streamFramer) {
                        StreamFramer.this.writeIntFrame(this.mPrefix, length);
                        this.mOut.write(buffer, offset, length);
                        this.mOut.flush();
                    }
                }
                catch (IOException e) {
                    throw new DumpappOutputBrokenException(e);
                }
            }
        }

        @Override
        public void write(int oneByte) throws IOException {
            byte[] buffer = new byte[]{(byte)oneByte};
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void close() throws IOException {
            this.mIsClosed = true;
        }
    }
}

