/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp;

import android.content.Context;
import com.facebook.stetho.dumpapp.DumpappHandler;
import com.facebook.stetho.dumpapp.Dumper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;

public class RawDumpappHandler
extends DumpappHandler {
    private static final String RESPONSE_HEADER_EXIT_CODE = "X-FAB-ExitCode";

    public RawDumpappHandler(Context context, Dumper dumper) {
        super(context, dumper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpEntity getResponseEntity(HttpRequest request, InputStream bufferedInput, HttpResponse response) throws IOException {
        ByteArrayOutputStream stdoutBuffer = new ByteArrayOutputStream();
        try (PrintStream stdout = new PrintStream(stdoutBuffer);){
            ByteArrayOutputStream stderrBuffer = new ByteArrayOutputStream();
            PrintStream stderr = new PrintStream(stderrBuffer);
            try {
                int exitCode = this.getDumper().dump(bufferedInput, stdout, stderr, RawDumpappHandler.getArgs(request));
                response.addHeader(RESPONSE_HEADER_EXIT_CODE, String.valueOf(exitCode));
            }
            finally {
                stderr.close();
                if (stderrBuffer.size() > 0) {
                    System.err.write(stderrBuffer.toByteArray());
                }
            }
        }
        finally {
            bufferedInput.close();
        }
        return RawDumpappHandler.createResponseEntity(stdoutBuffer.toByteArray());
    }

    private static HttpEntity createResponseEntity(byte[] data) {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        if (RawDumpappHandler.isProbablyBinaryData(data)) {
            entity.setContentType("application/octet-stream");
        } else {
            entity.setContentType("text/plain");
        }
        return entity;
    }

    private static boolean isProbablyBinaryData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            if (b < 127 && (b >= 32 || b == 13 || b == 10 || b == 9)) continue;
            return true;
        }
        return false;
    }
}

