/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp;

import com.facebook.stetho.dumpapp.DumpException;
import com.facebook.stetho.dumpapp.DumpappOutputBrokenException;
import com.facebook.stetho.dumpapp.DumperContext;
import com.facebook.stetho.dumpapp.DumperPlugin;
import com.facebook.stetho.dumpapp.GlobalOptions;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class Dumper {
    private final Map<String, DumperPlugin> mDumperPlugins;
    private final CommandLineParser mParser;
    private final GlobalOptions mGlobalOptions;

    public Dumper(Iterable<DumperPlugin> dumperPlugins) {
        this(dumperPlugins, (CommandLineParser)new GnuParser());
    }

    public Dumper(Iterable<DumperPlugin> dumperPlugins, CommandLineParser parser) {
        this.mDumperPlugins = Dumper.generatePluginMap(dumperPlugins);
        this.mParser = parser;
        this.mGlobalOptions = new GlobalOptions();
    }

    private static Map<String, DumperPlugin> generatePluginMap(Iterable<DumperPlugin> plugins) {
        HashMap<String, DumperPlugin> map = new HashMap<String, DumperPlugin>();
        for (DumperPlugin plugin : plugins) {
            map.put(plugin.getName(), plugin);
        }
        return Collections.unmodifiableMap(map);
    }

    public int dump(InputStream input, PrintStream out, PrintStream err, String[] args) {
        try {
            return this.doDump(input, out, err, args);
        }
        catch (ParseException e) {
            err.println(e.getMessage());
            this.dumpUsage(err);
            return 1;
        }
        catch (DumpException e) {
            err.println(e.getMessage());
            return 1;
        }
        catch (DumpappOutputBrokenException e) {
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace(err);
            return 1;
        }
    }

    private int doDump(InputStream input, PrintStream out, PrintStream err, String[] args) throws ParseException, DumpException {
        CommandLine parsedArgs = this.mParser.parse(this.mGlobalOptions.options, args, true);
        if (parsedArgs.hasOption(this.mGlobalOptions.optionHelp.getOpt())) {
            this.dumpUsage(out);
            return 0;
        }
        if (parsedArgs.hasOption(this.mGlobalOptions.optionListPlugins.getOpt())) {
            this.dumpAvailablePlugins(out);
            return 0;
        }
        if (!parsedArgs.getArgList().isEmpty()) {
            this.dumpPluginOutput(input, out, err, parsedArgs);
            return 0;
        }
        this.dumpUsage(err);
        return 1;
    }

    private void dumpAvailablePlugins(PrintStream output) {
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (DumperPlugin pluginToDump : this.mDumperPlugins.values()) {
            pluginNames.add(pluginToDump.getName());
        }
        Collections.sort(pluginNames);
        for (String pluginName : pluginNames) {
            output.println(pluginName);
        }
    }

    private void dumpPluginOutput(InputStream input, PrintStream out, PrintStream err, CommandLine parsedArgs) throws DumpException {
        ArrayList<String> args = new ArrayList<String>(parsedArgs.getArgList());
        if (args.size() < 1) {
            throw new DumpException("Expected plugin argument");
        }
        String pluginName = (String)args.remove(0);
        DumperPlugin plugin = this.mDumperPlugins.get(pluginName);
        if (plugin == null) {
            throw new DumpException("No plugin named '" + pluginName + "'");
        }
        DumperContext dumperContext = new DumperContext(input, out, err, this.mParser, args);
        plugin.dump(dumperContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUsage(PrintStream output) {
        String cmdName = "dumpapp";
        HelpFormatter formatter = new HelpFormatter();
        output.println("Usage: dumpapp [options] <plugin> [plugin-options]");
        PrintWriter writer = new PrintWriter(output);
        try {
            formatter.printOptions(writer, formatter.getWidth(), this.mGlobalOptions.options, formatter.getLeftPadding(), formatter.getDescPadding());
        }
        finally {
            writer.flush();
        }
    }
}

