/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.dumpapp;

import android.content.Context;
import android.net.Uri;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.dumpapp.Dumper;
import com.facebook.stetho.server.SecureHttpRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public abstract class DumpappHandler
extends SecureHttpRequestHandler {
    private static final String QUERY_PARAM_ARGV = "argv";
    private static final String RESPONSE_HEADER_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private final Dumper mDumper;

    public DumpappHandler(Context context, Dumper dumper) {
        super(context);
        this.mDumper = dumper;
    }

    protected abstract HttpEntity getResponseEntity(HttpRequest var1, InputStream var2, HttpResponse var3) throws IOException;

    protected Dumper getDumper() {
        return this.mDumper;
    }

    @Override
    protected void handleSecured(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        response.setEntity(this.getResponseEntity(request, DumpappHandler.bufferInput(request), response));
        response.addHeader(RESPONSE_HEADER_ALLOW_ORIGIN, "*");
        response.setStatusCode(200);
    }

    private static InputStream bufferInput(HttpRequest request) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        InputStream rawInput = DumpappHandler.getCallerInput(request);
        Util.copy(rawInput, buffer, new byte[256]);
        byte[] bytes = buffer.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private static InputStream getCallerInput(HttpRequest request) throws IOException {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            return entity.getContent();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    protected static String[] getArgs(HttpRequest request) {
        Uri requestUri = Uri.parse((String)request.getRequestLine().getUri());
        List argsList = requestUri.getQueryParameters(QUERY_PARAM_ARGV);
        return argsList.toArray(new String[argsList.size()]);
    }
}

