/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.PointF;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.facebook.stetho.common.Predicate;
import com.facebook.stetho.common.Util;
import javax.annotation.Nullable;

public final class ViewUtil {
    private ViewUtil() {
    }

    private static boolean isHittable(View view) {
        if (view.getVisibility() != 0) {
            return false;
        }
        return !(ViewCompat.getInstance().getAlpha(view) < 0.001f);
    }

    @Nullable
    public static View hitTest(View view, float x, float y) {
        return ViewUtil.hitTest(view, x, y, null);
    }

    @Nullable
    public static View hitTest(View view, float x, float y, @Nullable Predicate<View> viewSelector) {
        View result = ViewUtil.hitTestImpl(view, x, y, viewSelector, false);
        if (result == null) {
            result = ViewUtil.hitTestImpl(view, x, y, viewSelector, true);
        }
        return result;
    }

    private static View hitTestImpl(View view, float x, float y, @Nullable Predicate<View> viewSelector, boolean allowViewGroupResult) {
        if (!ViewUtil.isHittable(view)) {
            return null;
        }
        if (!ViewUtil.pointInView(view, x, y)) {
            return null;
        }
        if (viewSelector != null && !viewSelector.apply(view)) {
            return null;
        }
        if (!(view instanceof ViewGroup)) {
            return view;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        if (viewGroup.getChildCount() > 0) {
            PointF localPoint = new PointF();
            for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                View childResult;
                View child = viewGroup.getChildAt(i);
                if (!ViewUtil.isTransformedPointInView(viewGroup, child, x, y, localPoint) || (childResult = ViewUtil.hitTestImpl(child, localPoint.x, localPoint.y, viewSelector, allowViewGroupResult)) == null) continue;
                return childResult;
            }
        }
        return allowViewGroupResult ? viewGroup : null;
    }

    public static boolean pointInView(View view, float localX, float localY) {
        return localX >= 0.0f && localX < (float)(view.getRight() - view.getLeft()) && localY >= 0.0f && localY < (float)(view.getBottom() - view.getTop());
    }

    public static boolean isTransformedPointInView(ViewGroup parent, View child, float x, float y, @Nullable PointF outLocalPoint) {
        Util.throwIfNull(parent);
        Util.throwIfNull(child);
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        boolean isInView = ViewUtil.pointInView(child, localX, localY);
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(localX, localY);
        }
        return isInView;
    }

    @Nullable
    public static Activity tryGetActivity(View view) {
        if (view == null) {
            return null;
        }
        Context context = view.getContext();
        Activity activityFromContext = ViewUtil.tryGetActivity(context);
        if (activityFromContext != null) {
            return activityFromContext;
        }
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View parentView = (View)parent;
            return ViewUtil.tryGetActivity(parentView);
        }
        return null;
    }

    @Nullable
    private static Activity tryGetActivity(Context context) {
        while (context != null) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (context instanceof ContextWrapper) {
                context = ((ContextWrapper)context).getBaseContext();
                continue;
            }
            return null;
        }
        return null;
    }

    private static class ViewCompat {
        private static final ViewCompat sInstance = Build.VERSION.SDK_INT >= 11 ? new ViewCompatHoneycomb() : new ViewCompat();

        public static ViewCompat getInstance() {
            return sInstance;
        }

        protected ViewCompat() {
        }

        public float getAlpha(View view) {
            return 1.0f;
        }

        @TargetApi(value=11)
        private static class ViewCompatHoneycomb
        extends ViewCompat {
            private ViewCompatHoneycomb() {
            }

            @Override
            public float getAlpha(View view) {
                return view.getAlpha();
            }
        }
    }
}

