/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.content.res.Resources;
import com.facebook.stetho.common.LogUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourcesUtil {
    private ResourcesUtil() {
    }

    @Nonnull
    public static String getIdStringQuietly(Object idContext, @Nullable Resources r, int resourceId) {
        try {
            return ResourcesUtil.getIdString(r, resourceId);
        }
        catch (Resources.NotFoundException e) {
            String idString = ResourcesUtil.getFallbackIdString(resourceId);
            LogUtil.w("Unknown identifier encountered on " + idContext + ": " + idString);
            return idString;
        }
    }

    public static String getIdString(@Nullable Resources r, int resourceId) throws Resources.NotFoundException {
        String prefixSeparator;
        String prefix;
        if (r == null) {
            return ResourcesUtil.getFallbackIdString(resourceId);
        }
        switch (ResourcesUtil.getResourcePackageId(resourceId)) {
            case 127: {
                prefix = "";
                prefixSeparator = "";
                break;
            }
            default: {
                prefix = r.getResourcePackageName(resourceId);
                prefixSeparator = ":";
            }
        }
        String typeName = r.getResourceTypeName(resourceId);
        String entryName = r.getResourceEntryName(resourceId);
        StringBuilder sb = new StringBuilder(1 + prefix.length() + prefixSeparator.length() + typeName.length() + 1 + entryName.length());
        sb.append("@");
        sb.append(prefix);
        sb.append(prefixSeparator);
        sb.append(typeName);
        sb.append("/");
        sb.append(entryName);
        return sb.toString();
    }

    private static String getFallbackIdString(int resourceId) {
        return "#" + Integer.toHexString(resourceId);
    }

    private static int getResourcePackageId(int id2) {
        return id2 >>> 24 & 0xFF;
    }
}

