/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.os.Handler;
import android.os.Looper;
import com.facebook.stetho.common.UncheckedCallable;
import com.facebook.stetho.common.Util;

public final class HandlerUtil {
    private HandlerUtil() {
    }

    public static boolean checkThreadAccess(Handler handler) {
        return Looper.myLooper() == handler.getLooper();
    }

    public static void verifyThreadAccess(Handler handler) {
        Util.throwIfNot(HandlerUtil.checkThreadAccess(handler));
    }

    public static <V> V postAndWait(Handler handler, final UncheckedCallable<V> c) {
        if (HandlerUtil.checkThreadAccess(handler)) {
            try {
                return c.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        WaitableRunnable wrapper = new WaitableRunnable<V>(){

            @Override
            protected V onRun() {
                return c.call();
            }
        };
        return wrapper.invoke(handler);
    }

    public static void postAndWait(Handler handler, final Runnable r) {
        if (HandlerUtil.checkThreadAccess(handler)) {
            try {
                r.run();
                return;
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        WaitableRunnable<Void> wrapper = new WaitableRunnable<Void>(){

            @Override
            protected Void onRun() {
                r.run();
                return null;
            }
        };
        wrapper.invoke(handler);
    }

    private static abstract class WaitableRunnable<V>
    implements Runnable {
        private boolean mIsDone;
        private V mValue;
        private Exception mException;

        protected WaitableRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                this.mValue = this.onRun();
                this.mException = null;
            }
            catch (Exception e) {
                this.mValue = null;
                this.mException = e;
            }
            finally {
                WaitableRunnable waitableRunnable = this;
                synchronized (waitableRunnable) {
                    this.mIsDone = true;
                    this.notifyAll();
                }
            }
        }

        protected abstract V onRun();

        public V invoke(Handler handler) {
            if (!handler.post((Runnable)this)) {
                throw new RuntimeException("Handler.post() returned false");
            }
            this.join();
            if (this.mException != null) {
                throw new RuntimeException(this.mException);
            }
            return this.mValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void join() {
            WaitableRunnable waitableRunnable = this;
            synchronized (waitableRunnable) {
                while (!this.mIsDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

