/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.app.Dialog;
import android.content.res.Resources;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.facebook.stetho.common.android.DialogFragmentAccessor;
import com.facebook.stetho.common.android.FragmentAccessor;
import com.facebook.stetho.common.android.FragmentActivityAccessor;
import com.facebook.stetho.common.android.FragmentCompat;
import com.facebook.stetho.common.android.FragmentManagerAccessor;
import javax.annotation.Nullable;

final class FragmentCompatSupportLib
extends FragmentCompat<Fragment, DialogFragment, FragmentManager, FragmentActivity> {
    private static final FragmentAccessorSupportLib sFragmentAccessor = new FragmentAccessorSupportLib();
    private static final DialogFragmentAccessorSupportLib sDialogFragmentAccessor = new DialogFragmentAccessorSupportLib();
    private static final FragmentCompat.FragmentManagerAccessorViaReflection<FragmentManager, Fragment> sFragmentManagerAccessor = new FragmentCompat.FragmentManagerAccessorViaReflection();
    private static final FragmentActivityAccessorSupportLib sFragmentActivityAccessor = new FragmentActivityAccessorSupportLib();

    FragmentCompatSupportLib() {
    }

    @Override
    public Class<Fragment> getFragmentClass() {
        return Fragment.class;
    }

    @Override
    public Class<DialogFragment> getDialogFragmentClass() {
        return DialogFragment.class;
    }

    @Override
    public Class<FragmentActivity> getFragmentActivityClass() {
        return FragmentActivity.class;
    }

    public FragmentAccessorSupportLib forFragment() {
        return sFragmentAccessor;
    }

    public DialogFragmentAccessorSupportLib forDialogFragment() {
        return sDialogFragmentAccessor;
    }

    @Override
    public FragmentManagerAccessor<FragmentManager, Fragment> forFragmentManager() {
        return sFragmentManagerAccessor;
    }

    public FragmentActivityAccessorSupportLib forFragmentActivity() {
        return sFragmentActivityAccessor;
    }

    private static class FragmentActivityAccessorSupportLib
    implements FragmentActivityAccessor<FragmentActivity, FragmentManager> {
        private FragmentActivityAccessorSupportLib() {
        }

        @Override
        @Nullable
        public FragmentManager getFragmentManager(FragmentActivity activity) {
            return activity.getSupportFragmentManager();
        }
    }

    private static class DialogFragmentAccessorSupportLib
    extends FragmentAccessorSupportLib
    implements DialogFragmentAccessor<DialogFragment, Fragment, FragmentManager> {
        private DialogFragmentAccessorSupportLib() {
        }

        @Override
        public Dialog getDialog(DialogFragment dialogFragment) {
            return dialogFragment.getDialog();
        }
    }

    private static class FragmentAccessorSupportLib
    implements FragmentAccessor<Fragment, FragmentManager> {
        private FragmentAccessorSupportLib() {
        }

        @Override
        @Nullable
        public FragmentManager getFragmentManager(Fragment fragment) {
            return fragment.getFragmentManager();
        }

        @Override
        public Resources getResources(Fragment fragment) {
            return fragment.getResources();
        }

        @Override
        public int getId(Fragment fragment) {
            return fragment.getId();
        }

        @Override
        @Nullable
        public String getTag(Fragment fragment) {
            return fragment.getTag();
        }

        @Override
        @Nullable
        public View getView(Fragment fragment) {
            return fragment.getView();
        }

        @Override
        @Nullable
        public FragmentManager getChildFragmentManager(Fragment fragment) {
            return fragment.getChildFragmentManager();
        }
    }
}

