/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import com.facebook.stetho.common.android.DialogFragmentAccessor;
import com.facebook.stetho.common.android.FragmentAccessor;
import com.facebook.stetho.common.android.FragmentActivityAccessor;
import com.facebook.stetho.common.android.FragmentCompat;
import javax.annotation.Nullable;

@TargetApi(value=11)
final class FragmentCompatFramework
extends FragmentCompat<Fragment, DialogFragment, FragmentManager, Activity> {
    private static final FragmentAccessorFrameworkHoneycomb sFragmentAccessor;
    private static final DialogFragmentAccessorFramework sDialogFragmentAccessor;
    private static final FragmentCompat.FragmentManagerAccessorViaReflection<FragmentManager, Fragment> sFragmentManagerAccessor;
    private static final FragmentActivityAccessorFramework sFragmentActivityAccessor;

    FragmentCompatFramework() {
    }

    @Override
    public Class<Fragment> getFragmentClass() {
        return Fragment.class;
    }

    @Override
    public Class<DialogFragment> getDialogFragmentClass() {
        return DialogFragment.class;
    }

    @Override
    public Class<Activity> getFragmentActivityClass() {
        return Activity.class;
    }

    public FragmentAccessorFrameworkHoneycomb forFragment() {
        return sFragmentAccessor;
    }

    public DialogFragmentAccessorFramework forDialogFragment() {
        return sDialogFragmentAccessor;
    }

    @Override
    public FragmentCompat.FragmentManagerAccessorViaReflection<FragmentManager, Fragment> forFragmentManager() {
        return sFragmentManagerAccessor;
    }

    public FragmentActivityAccessorFramework forFragmentActivity() {
        return sFragmentActivityAccessor;
    }

    static {
        sFragmentManagerAccessor = new FragmentCompat.FragmentManagerAccessorViaReflection();
        sFragmentActivityAccessor = new FragmentActivityAccessorFramework();
        sFragmentAccessor = Build.VERSION.SDK_INT >= 17 ? new FragmentAccessorFrameworkJellyBean() : new FragmentAccessorFrameworkHoneycomb();
        sDialogFragmentAccessor = new DialogFragmentAccessorFramework(sFragmentAccessor);
    }

    private static class FragmentActivityAccessorFramework
    implements FragmentActivityAccessor<Activity, FragmentManager> {
        private FragmentActivityAccessorFramework() {
        }

        @Override
        @Nullable
        public FragmentManager getFragmentManager(Activity activity) {
            return activity.getFragmentManager();
        }
    }

    private static class DialogFragmentAccessorFramework
    implements DialogFragmentAccessor<DialogFragment, Fragment, FragmentManager> {
        private final FragmentAccessor<Fragment, FragmentManager> mFragmentAccessor;

        public DialogFragmentAccessorFramework(FragmentAccessor<Fragment, FragmentManager> fragmentAccessor) {
            this.mFragmentAccessor = fragmentAccessor;
        }

        @Override
        public Dialog getDialog(DialogFragment dialogFragment) {
            return dialogFragment.getDialog();
        }

        @Override
        @Nullable
        public FragmentManager getFragmentManager(Fragment fragment) {
            return this.mFragmentAccessor.getFragmentManager(fragment);
        }

        @Override
        public Resources getResources(Fragment fragment) {
            return this.mFragmentAccessor.getResources(fragment);
        }

        @Override
        public int getId(Fragment fragment) {
            return this.mFragmentAccessor.getId(fragment);
        }

        @Override
        @Nullable
        public String getTag(Fragment fragment) {
            return this.mFragmentAccessor.getTag(fragment);
        }

        @Override
        @Nullable
        public View getView(Fragment fragment) {
            return this.mFragmentAccessor.getView(fragment);
        }

        @Override
        @Nullable
        public FragmentManager getChildFragmentManager(Fragment fragment) {
            return this.mFragmentAccessor.getChildFragmentManager(fragment);
        }
    }

    @TargetApi(value=17)
    private static class FragmentAccessorFrameworkJellyBean
    extends FragmentAccessorFrameworkHoneycomb {
        private FragmentAccessorFrameworkJellyBean() {
        }

        @Override
        @Nullable
        public FragmentManager getChildFragmentManager(Fragment fragment) {
            return fragment.getChildFragmentManager();
        }
    }

    private static class FragmentAccessorFrameworkHoneycomb
    implements FragmentAccessor<Fragment, FragmentManager> {
        private FragmentAccessorFrameworkHoneycomb() {
        }

        @Override
        @Nullable
        public FragmentManager getFragmentManager(Fragment fragment) {
            return fragment.getFragmentManager();
        }

        @Override
        public Resources getResources(Fragment fragment) {
            return fragment.getResources();
        }

        @Override
        public int getId(Fragment fragment) {
            return fragment.getId();
        }

        @Override
        @Nullable
        public String getTag(Fragment fragment) {
            return fragment.getTag();
        }

        @Override
        @Nullable
        public View getView(Fragment fragment) {
            return fragment.getView();
        }

        @Override
        @Nullable
        public FragmentManager getChildFragmentManager(Fragment fragment) {
            return null;
        }
    }
}

