/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common.android;

import android.app.Activity;
import android.os.Build;
import com.facebook.stetho.common.ReflectionUtil;
import com.facebook.stetho.common.android.DialogFragmentAccessor;
import com.facebook.stetho.common.android.FragmentAccessor;
import com.facebook.stetho.common.android.FragmentActivityAccessor;
import com.facebook.stetho.common.android.FragmentCompatFramework;
import com.facebook.stetho.common.android.FragmentCompatSupportLib;
import com.facebook.stetho.common.android.FragmentManagerAccessor;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class FragmentCompat<FRAGMENT, DIALOG_FRAGMENT, FRAGMENT_MANAGER, FRAGMENT_ACTIVITY extends Activity> {
    private static FragmentCompat sFrameworkInstance;
    private static FragmentCompat sSupportInstance;
    private static final boolean sHasSupportFragment;

    @Nullable
    public static FragmentCompat getFrameworkInstance() {
        if (sFrameworkInstance == null && Build.VERSION.SDK_INT >= 11) {
            sFrameworkInstance = new FragmentCompatFramework();
        }
        return sFrameworkInstance;
    }

    @Nullable
    public static FragmentCompat getSupportLibInstance() {
        if (sSupportInstance == null && sHasSupportFragment) {
            sSupportInstance = new FragmentCompatSupportLib();
        }
        return sSupportInstance;
    }

    FragmentCompat() {
    }

    public abstract Class<FRAGMENT> getFragmentClass();

    public abstract Class<DIALOG_FRAGMENT> getDialogFragmentClass();

    public abstract Class<FRAGMENT_ACTIVITY> getFragmentActivityClass();

    public abstract FragmentAccessor<FRAGMENT, FRAGMENT_MANAGER> forFragment();

    public abstract DialogFragmentAccessor<DIALOG_FRAGMENT, FRAGMENT, FRAGMENT_MANAGER> forDialogFragment();

    public abstract FragmentManagerAccessor<FRAGMENT_MANAGER, FRAGMENT> forFragmentManager();

    public abstract FragmentActivityAccessor<FRAGMENT_ACTIVITY, FRAGMENT_MANAGER> forFragmentActivity();

    static {
        sHasSupportFragment = ReflectionUtil.tryGetClassForName("android.support.v4.app.Fragment") != null;
    }

    static class FragmentManagerAccessorViaReflection<FRAGMENT_MANAGER, FRAGMENT>
    implements FragmentManagerAccessor<FRAGMENT_MANAGER, FRAGMENT> {
        @Nullable
        private Field mFieldMAdded;

        FragmentManagerAccessorViaReflection() {
        }

        @Override
        @Nullable
        public List<FRAGMENT> getAddedFragments(FRAGMENT_MANAGER fragmentManager) {
            Field fieldMAdded;
            if (this.mFieldMAdded == null && (fieldMAdded = ReflectionUtil.tryGetDeclaredField(fragmentManager.getClass(), "mAdded")) != null) {
                fieldMAdded.setAccessible(true);
                this.mFieldMAdded = fieldMAdded;
            }
            return this.mFieldMAdded != null ? (List)ReflectionUtil.getFieldValue(this.mFieldMAdded, fragmentManager) : null;
        }
    }
}

