/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common;

import com.facebook.stetho.common.Util;
import java.io.FileInputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public class ProcessUtil {
    private static final int CMDLINE_BUFFER_SIZE = 64;
    private static String sProcessName;
    private static boolean sProcessNameRead;

    @Nullable
    public static synchronized String getProcessName() {
        if (!sProcessNameRead) {
            sProcessNameRead = true;
            try {
                sProcessName = ProcessUtil.readProcessName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcessName() throws IOException {
        String string2;
        byte[] cmdlineBuffer = new byte[64];
        FileInputStream stream = new FileInputStream("/proc/self/cmdline");
        boolean success = false;
        try {
            int n = stream.read(cmdlineBuffer);
            success = true;
            int endIndex = ProcessUtil.indexOf(cmdlineBuffer, 0, n, (byte)0);
            string2 = new String(cmdlineBuffer, 0, endIndex > 0 ? endIndex : n);
            Util.close(stream, !success);
        }
        catch (Throwable throwable) {
            Util.close(stream, !success);
            throw throwable;
        }
        return string2;
    }

    private static int indexOf(byte[] haystack, int offset, int length, byte needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }
}

