/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.common;

import android.util.Log;
import com.facebook.stetho.common.Util;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogRedirector {
    private static volatile Logger sLogger;

    public static void setLogger(Logger logger) {
        Util.throwIfNull(logger);
        Util.throwIfNotNull(sLogger);
        sLogger = logger;
    }

    public static void e(String tag, String message, Throwable t) {
        LogRedirector.e(tag, message + "\n" + LogRedirector.formatThrowable(t));
    }

    public static void e(String tag, String message) {
        LogRedirector.log(6, tag, message);
    }

    public static void w(String tag, String message, Throwable t) {
        LogRedirector.w(tag, message + "\n" + LogRedirector.formatThrowable(t));
    }

    public static void w(String tag, String message) {
        LogRedirector.log(5, tag, message);
    }

    public static void i(String tag, String message, Throwable t) {
        LogRedirector.i(tag, message + "\n" + LogRedirector.formatThrowable(t));
    }

    public static void i(String tag, String message) {
        LogRedirector.log(4, tag, message);
    }

    public static void d(String tag, String message, Throwable t) {
        LogRedirector.d(tag, message + "\n" + LogRedirector.formatThrowable(t));
    }

    public static void d(String tag, String message) {
        LogRedirector.log(3, tag, message);
    }

    public static void v(String tag, String message, Throwable t) {
        LogRedirector.v(tag, message + "\n" + LogRedirector.formatThrowable(t));
    }

    public static void v(String tag, String message) {
        LogRedirector.log(2, tag, message);
    }

    private static String formatThrowable(Throwable t) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        t.printStackTrace();
        writer.flush();
        return buf.toString();
    }

    private static void log(int priority, String tag, String message) {
        Logger logger = sLogger;
        if (logger != null) {
            logger.log(priority, tag, message);
        } else {
            Log.println((int)priority, (String)tag, (String)message);
        }
    }

    public static boolean isLoggable(String tag, int priority) {
        Logger logger = sLogger;
        if (logger != null) {
            return logger.isLoggable(tag, priority);
        }
        return Log.isLoggable((String)tag, (int)priority);
    }

    public static interface Logger {
        public boolean isLoggable(String var1, int var2);

        public void log(int var1, String var2, String var3);
    }
}

