/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import com.facebook.stetho.DumperPluginsProvider;
import com.facebook.stetho.InspectorModulesProvider;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.common.Util;
import com.facebook.stetho.dumpapp.Dumper;
import com.facebook.stetho.dumpapp.DumperPlugin;
import com.facebook.stetho.dumpapp.RawDumpappHandler;
import com.facebook.stetho.dumpapp.StreamingDumpappHandler;
import com.facebook.stetho.dumpapp.plugins.CrashDumperPlugin;
import com.facebook.stetho.dumpapp.plugins.FilesDumperPlugin;
import com.facebook.stetho.dumpapp.plugins.HprofDumperPlugin;
import com.facebook.stetho.dumpapp.plugins.SharedPreferencesDumperPlugin;
import com.facebook.stetho.inspector.ChromeDevtoolsServer;
import com.facebook.stetho.inspector.ChromeDiscoveryHandler;
import com.facebook.stetho.inspector.console.RuntimeReplFactory;
import com.facebook.stetho.inspector.database.DatabaseFilesProvider;
import com.facebook.stetho.inspector.database.DefaultDatabaseFilesProvider;
import com.facebook.stetho.inspector.elements.Document;
import com.facebook.stetho.inspector.elements.DocumentProviderFactory;
import com.facebook.stetho.inspector.elements.android.ActivityTracker;
import com.facebook.stetho.inspector.elements.android.AndroidDocumentProviderFactory;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.module.CSS;
import com.facebook.stetho.inspector.protocol.module.Console;
import com.facebook.stetho.inspector.protocol.module.DOM;
import com.facebook.stetho.inspector.protocol.module.DOMStorage;
import com.facebook.stetho.inspector.protocol.module.Database;
import com.facebook.stetho.inspector.protocol.module.Debugger;
import com.facebook.stetho.inspector.protocol.module.HeapProfiler;
import com.facebook.stetho.inspector.protocol.module.Inspector;
import com.facebook.stetho.inspector.protocol.module.Network;
import com.facebook.stetho.inspector.protocol.module.Page;
import com.facebook.stetho.inspector.protocol.module.Profiler;
import com.facebook.stetho.inspector.protocol.module.Runtime;
import com.facebook.stetho.inspector.protocol.module.Worker;
import com.facebook.stetho.inspector.runtime.RhinoDetectingRuntimeReplFactory;
import com.facebook.stetho.server.LocalSocketHttpServer;
import com.facebook.stetho.server.RegistryInitializer;
import com.facebook.stetho.websocket.WebSocketHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;

public class Stetho {
    private static final String LISTENER_THREAD_NAME = "Stetho-Listener";

    private Stetho() {
    }

    public static InitializerBuilder newInitializerBuilder(Context context) {
        return new InitializerBuilder(context);
    }

    public static void initializeWithDefaults(final Context context) {
        Stetho.initialize(new Initializer(context){

            @Override
            protected Iterable<DumperPlugin> getDumperPlugins() {
                return new DefaultDumperPluginsBuilder(context).finish();
            }

            @Override
            protected Iterable<ChromeDevtoolsDomain> getInspectorModules() {
                return new DefaultInspectorModulesBuilder(context).finish();
            }
        });
    }

    public static void initialize(final Initializer initializer) {
        boolean isTrackingActivities = ActivityTracker.get().beginTrackingIfPossible((Application)initializer.mContext.getApplicationContext());
        if (!isTrackingActivities) {
            LogUtil.w("Automatic activity tracking not available on this API level, caller must invoke ActivityTracker methods manually!");
        }
        Thread listener = new Thread(LISTENER_THREAD_NAME){

            @Override
            public void run() {
                LocalSocketHttpServer server = new LocalSocketHttpServer(initializer);
                try {
                    server.run();
                }
                catch (IOException e) {
                    LogUtil.e(e, "Could not start Stetho");
                }
            }
        };
        listener.start();
    }

    public static DumperPluginsProvider defaultDumperPluginsProvider(final Context context) {
        return new DumperPluginsProvider(){

            @Override
            public Iterable<DumperPlugin> get() {
                return new DefaultDumperPluginsBuilder(context).finish();
            }
        };
    }

    public static InspectorModulesProvider defaultInspectorModulesProvider(final Context context) {
        return new InspectorModulesProvider(){

            @Override
            public Iterable<ChromeDevtoolsDomain> get() {
                return new DefaultInspectorModulesBuilder(context).finish();
            }
        };
    }

    private static class BuilderBasedInitializer
    extends Initializer {
        @Nullable
        private final DumperPluginsProvider mDumperPlugins;
        @Nullable
        private final InspectorModulesProvider mInspectorModules;

        private BuilderBasedInitializer(InitializerBuilder b) {
            super(b.mContext);
            this.mDumperPlugins = b.mDumperPlugins;
            this.mInspectorModules = b.mInspectorModules;
        }

        @Override
        @Nullable
        protected Iterable<DumperPlugin> getDumperPlugins() {
            return this.mDumperPlugins != null ? this.mDumperPlugins.get() : null;
        }

        @Override
        @Nullable
        protected Iterable<ChromeDevtoolsDomain> getInspectorModules() {
            return this.mInspectorModules != null ? this.mInspectorModules.get() : null;
        }
    }

    public static class InitializerBuilder {
        final Context mContext;
        @Nullable
        DumperPluginsProvider mDumperPlugins;
        @Nullable
        InspectorModulesProvider mInspectorModules;

        private InitializerBuilder(Context context) {
            this.mContext = context.getApplicationContext();
        }

        public InitializerBuilder enableDumpapp(DumperPluginsProvider plugins) {
            this.mDumperPlugins = Util.throwIfNull(plugins);
            return this;
        }

        public InitializerBuilder enableWebKitInspector(InspectorModulesProvider modules) {
            this.mInspectorModules = modules;
            return this;
        }

        public Initializer build() {
            return new BuilderBasedInitializer(this);
        }
    }

    public static abstract class Initializer
    implements RegistryInitializer {
        private final Context mContext;

        protected Initializer(Context context) {
            this.mContext = context.getApplicationContext();
        }

        @Override
        public final HttpRequestHandlerRegistry getRegistry() {
            Iterable<ChromeDevtoolsDomain> inspectorModules;
            HttpRequestHandlerRegistry registry = new HttpRequestHandlerRegistry();
            Iterable<DumperPlugin> dumperPlugins = this.getDumperPlugins();
            if (dumperPlugins != null) {
                Dumper dumper = new Dumper(dumperPlugins);
                registry.register("/dumpapp", (HttpRequestHandler)new StreamingDumpappHandler(this.mContext, dumper));
                registry.register("/dumpapp-raw", (HttpRequestHandler)new RawDumpappHandler(this.mContext, dumper));
            }
            if ((inspectorModules = this.getInspectorModules()) != null) {
                ChromeDiscoveryHandler discoveryHandler = new ChromeDiscoveryHandler(this.mContext, "/inspector");
                discoveryHandler.register(registry);
                registry.register("/inspector", (HttpRequestHandler)new WebSocketHandler(this.mContext, new ChromeDevtoolsServer(inspectorModules)));
            }
            this.addCustomEntries(registry);
            registry.register("/*", (HttpRequestHandler)new LoggingCatchAllHandler());
            return registry;
        }

        @Nullable
        protected abstract Iterable<DumperPlugin> getDumperPlugins();

        @Nullable
        protected abstract Iterable<ChromeDevtoolsDomain> getInspectorModules();

        protected void addCustomEntries(HttpRequestHandlerRegistry registry) {
        }

        private static class LoggingCatchAllHandler
        implements HttpRequestHandler {
            private LoggingCatchAllHandler() {
            }

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                LogUtil.w("Unsupported request received: " + request.getRequestLine());
                response.setStatusCode(404);
                response.setReasonPhrase("Not Found");
                response.setEntity((HttpEntity)new StringEntity("Endpoint not implemented\n", "UTF-8"));
            }
        }
    }

    public static final class DefaultInspectorModulesBuilder {
        private final Application mContext;
        private final PluginBuilder<ChromeDevtoolsDomain> mDelegate = new PluginBuilder();
        @Nullable
        private DocumentProviderFactory mDocumentProvider;
        @Nullable
        private RuntimeReplFactory mRuntimeRepl;
        @Nullable
        private DatabaseFilesProvider mDatabaseFiles;

        public DefaultInspectorModulesBuilder(Context context) {
            this.mContext = (Application)context.getApplicationContext();
        }

        public DefaultInspectorModulesBuilder documentProvider(DocumentProviderFactory factory) {
            this.mDocumentProvider = factory;
            return this;
        }

        public DefaultInspectorModulesBuilder runtimeRepl(RuntimeReplFactory factory) {
            this.mRuntimeRepl = factory;
            return this;
        }

        public DefaultInspectorModulesBuilder databaseFiles(DatabaseFilesProvider provider) {
            this.mDatabaseFiles = provider;
            return this;
        }

        @Deprecated
        public DefaultInspectorModulesBuilder provide(ChromeDevtoolsDomain module) {
            this.mDelegate.provide(module.getClass().getName(), module);
            return this;
        }

        private DefaultInspectorModulesBuilder provideIfDesired(ChromeDevtoolsDomain module) {
            this.mDelegate.provideIfDesired(module.getClass().getName(), module);
            return this;
        }

        @Deprecated
        public DefaultInspectorModulesBuilder remove(String moduleName) {
            this.mDelegate.remove(moduleName);
            return this;
        }

        public Iterable<ChromeDevtoolsDomain> finish() {
            this.provideIfDesired(new Console());
            this.provideIfDesired(new Debugger());
            DocumentProviderFactory documentModel = this.resolveDocumentProvider();
            if (documentModel != null) {
                Document document = new Document(documentModel);
                this.provideIfDesired(new DOM(document));
                this.provideIfDesired(new CSS(document));
            }
            this.provideIfDesired(new DOMStorage((Context)this.mContext));
            this.provideIfDesired(new HeapProfiler());
            this.provideIfDesired(new Inspector());
            this.provideIfDesired(new Network((Context)this.mContext));
            this.provideIfDesired(new Page((Context)this.mContext));
            this.provideIfDesired(new Profiler());
            this.provideIfDesired(new Runtime(this.mRuntimeRepl != null ? this.mRuntimeRepl : new RhinoDetectingRuntimeReplFactory((Context)this.mContext)));
            this.provideIfDesired(new Worker());
            if (Build.VERSION.SDK_INT >= 11) {
                this.provideIfDesired(new Database((Context)this.mContext, this.mDatabaseFiles != null ? this.mDatabaseFiles : new DefaultDatabaseFilesProvider((Context)this.mContext)));
            }
            return this.mDelegate.finish();
        }

        @Nullable
        private DocumentProviderFactory resolveDocumentProvider() {
            if (this.mDocumentProvider != null) {
                return this.mDocumentProvider;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                return new AndroidDocumentProviderFactory(this.mContext);
            }
            return null;
        }
    }

    public static final class DefaultDumperPluginsBuilder {
        private final Context mContext;
        private final PluginBuilder<DumperPlugin> mDelegate = new PluginBuilder();

        public DefaultDumperPluginsBuilder(Context context) {
            this.mContext = context;
        }

        public DefaultDumperPluginsBuilder provide(DumperPlugin plugin) {
            this.mDelegate.provide(plugin.getName(), plugin);
            return this;
        }

        private DefaultDumperPluginsBuilder provideIfDesired(DumperPlugin plugin) {
            this.mDelegate.provideIfDesired(plugin.getName(), plugin);
            return this;
        }

        public DefaultDumperPluginsBuilder remove(String pluginName) {
            this.mDelegate.remove(pluginName);
            return this;
        }

        public Iterable<DumperPlugin> finish() {
            this.provideIfDesired(new HprofDumperPlugin(this.mContext));
            this.provideIfDesired(new SharedPreferencesDumperPlugin(this.mContext));
            this.provideIfDesired(new CrashDumperPlugin());
            this.provideIfDesired(new FilesDumperPlugin(this.mContext));
            return this.mDelegate.finish();
        }
    }

    private static class PluginBuilder<T> {
        private final Set<String> mProvidedNames = new HashSet<String>();
        private final Set<String> mRemovedNames = new HashSet<String>();
        private final ArrayList<T> mPlugins = new ArrayList();
        private boolean mFinished;

        private PluginBuilder() {
        }

        public void provide(String name, T plugin) {
            this.throwIfFinished();
            this.mPlugins.add(plugin);
            this.mProvidedNames.add(name);
        }

        public void provideIfDesired(String name, T plugin) {
            this.throwIfFinished();
            if (!this.mRemovedNames.contains(name) && this.mProvidedNames.add(name)) {
                this.mPlugins.add(plugin);
            }
        }

        public void remove(String pluginName) {
            this.throwIfFinished();
            this.mRemovedNames.remove(pluginName);
        }

        private void throwIfFinished() {
            if (this.mFinished) {
                throw new IllegalStateException("Must not continue to build after finish()");
            }
        }

        public Iterable<T> finish() {
            this.mFinished = true;
            return this.mPlugins;
        }
    }
}

