/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.auth;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegedSaslClient {
    private static final Logger logger = LoggerFactory.getLogger(PrivilegedSaslClient.class);
    public static final Map<String, String> DEFAULT_PROPERTIES = new HashMap<String, String>(){
        {
            this.put("javax.security.sasl.server.authentication", "true");
            this.put("javax.security.sasl.qop", "auth");
        }
    };
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final SaslClient saslClient;
    private Subject clientIdentity;

    public PrivilegedSaslClient(Subject clientIdentity, final String[] mechanisms, final String authzId, final String protocol, final String hostname, final Map<String, String> properties, final CallbackHandler callbackHandler) {
        logger.trace("Initalising SASL client");
        this.clientIdentity = clientIdentity;
        this.saslClient = Subject.doAs(this.clientIdentity, new PrivilegedAction<SaslClient>(){

            @Override
            public SaslClient run() {
                try {
                    return Sasl.createSaslClient(mechanisms, authzId, protocol, hostname, properties, callbackHandler);
                }
                catch (Exception e) {
                    logger.error("Error initialising SASL client", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
        logger.trace("SASL client initialised");
    }

    public byte[] getInitialResponse() {
        logger.trace("Initialising SASL handshake from client");
        byte[] initialResponse = null;
        if (this.saslClient.hasInitialResponse()) {
            initialResponse = Subject.doAs(this.clientIdentity, new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        return PrivilegedSaslClient.this.saslClient.evaluateChallenge(EMPTY_BYTE_ARRAY);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return initialResponse;
    }

    public byte[] evaluateChallenge(final byte[] challenge) {
        logger.trace("Evaluating SASL server token");
        if (this.saslClient.isComplete()) {
            return null;
        }
        byte[] retval = Subject.doAs(this.clientIdentity, new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                try {
                    logger.trace("SASL client evaluating challenge");
                    byte[] retval = PrivilegedSaslClient.this.saslClient.evaluateChallenge(challenge);
                    logger.trace("SASL client is complete = " + PrivilegedSaslClient.this.saslClient.isComplete());
                    return retval;
                }
                catch (SaslException e) {
                    logger.error("Failed to generate response to SASL server's token:", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
        return retval;
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }
}

