/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableData;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.List;

class ArrayBackedRow
extends AbstractGettableData
implements Row {
    private final ColumnDefinitions metadata;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata, int protocolVersion, List<ByteBuffer> data) {
        super(protocolVersion);
        this.metadata = metadata;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata, int protocolVersion, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new ArrayBackedRow(metadata, protocolVersion, data);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    protected DataType getType(int i) {
        return this.metadata.getType(i);
    }

    @Override
    protected String getName(int i) {
        return this.metadata.getName(i);
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.data.get(i);
    }

    @Override
    protected int getIndexOf(String name) {
        return this.metadata.getFirstIdx(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.metadata.getType(i).codec(this.protocolVersion).deserialize(bb).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

