/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.zookeeper;

import com.dangdang.config.service.ConfigProfile;
import org.apache.curator.RetryPolicy;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;

public class ZookeeperConfigProfile
extends ConfigProfile {
    private static final ExponentialBackoffRetry DEFAULT_RETRY_POLICY = new ExponentialBackoffRetry(1000, 3);
    private final String connectStr;
    private final String rootNode;
    private final RetryPolicy retryPolicy;
    private final boolean openLocalCache;

    public ZookeeperConfigProfile(String connectStr, String rootNode, String version) {
        this(connectStr, rootNode, version, false);
    }

    public ZookeeperConfigProfile(String connectStr, String rootNode, String version, boolean openLocalCache) {
        this(connectStr, rootNode, version, openLocalCache, (RetryPolicy)DEFAULT_RETRY_POLICY);
    }

    public ZookeeperConfigProfile(String connectStr, String rootNode, String version, boolean openLocalCache, RetryPolicy retryPolicy) {
        super(version);
        if (connectStr == null || rootNode == null || retryPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.connectStr = connectStr;
        this.rootNode = rootNode;
        this.retryPolicy = retryPolicy;
        this.openLocalCache = openLocalCache;
    }

    public String getConnectStr() {
        return this.connectStr;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public String getVersionedRootNode() {
        if (this.version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        return ZKPaths.makePath((String)this.rootNode, (String)this.version);
    }

    public boolean isOpenLocalCache() {
        return this.openLocalCache;
    }

    public String toString() {
        return "ZookeeperConfigProfile{connectStr='" + this.connectStr + '\'' + ", rootNode='" + this.rootNode + '\'' + ", retryPolicy=" + this.retryPolicy + ", openLocalCache=" + this.openLocalCache + '}';
    }
}

