/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file.protocol;

import com.dangdang.config.service.file.protocol.Protocol;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class Protocols {
    private Map<String, Class<Protocol>> protocols;
    private static Protocols INSTANCE = new Protocols();
    private static final String REGISTER_FILE = "META-INF/toolkit/com.dangdang.config.service.file.protocol.Protocol";

    private Protocols() {
        try {
            Properties props = new Properties();
            Enumeration<URL> registerFiles = this.getClass().getClassLoader().getResources(REGISTER_FILE);
            URL registerFile = null;
            while (registerFiles.hasMoreElements()) {
                registerFile = registerFiles.nextElement();
                InputStream in = registerFile.openStream();
                Throwable throwable = null;
                try {
                    props.load(in);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            this.protocols = new HashMap<String, Class<Protocol>>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String protocolName = ((String)entry.getKey()).toLowerCase();
                Class<?> protocolBeanClazz = Class.forName((String)entry.getValue());
                this.protocols.put(protocolName, protocolBeanClazz);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Protocols getInstance() {
        return INSTANCE;
    }

    public Class<Protocol> get(String protocolName) {
        Class<Protocol> protocolClass = this.protocols.get(protocolName);
        if (protocolClass == null) {
            throw new IllegalArgumentException("Procotol with name " + protocolName + " not registered.");
        }
        return protocolClass;
    }
}

