/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file.protocol;

import com.dangdang.config.service.exception.InvalidPathException;
import com.dangdang.config.service.file.FileChangeEventListener;
import com.dangdang.config.service.file.FileConfigGroup;
import com.dangdang.config.service.file.FileLocation;
import com.dangdang.config.service.file.protocol.Protocol;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;

public abstract class LocalFileProtocol
implements Protocol {
    private WatchService watcher;

    @Override
    public final byte[] read(FileLocation location) throws InvalidPathException {
        try {
            Path path = this.getPath(location);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new InvalidPathException("The file is not exists.");
            }
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new InvalidPathException(e);
        }
    }

    @Override
    public final void watch(FileLocation location, FileConfigGroup fileConfigGroup) throws InvalidPathException {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            Path path = this.getPath(location).toAbsolutePath();
            path.getParent().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            new Thread(new FileChangeEventListener(this.watcher, fileConfigGroup, path)).start();
        }
        catch (IOException e) {
            throw new InvalidPathException(e);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected abstract Path getPath(FileLocation var1) throws InvalidPathException;

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            this.watcher.close();
        }
    }
}

