/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file.protocol;

import com.dangdang.config.service.exception.InvalidPathException;
import com.dangdang.config.service.file.FileLocation;
import com.dangdang.config.service.file.protocol.LocalFileProtocol;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class ClasspathProtocol
extends LocalFileProtocol {
    private static Map<String, FileSystem> fsMap = new HashMap<String, FileSystem>();

    @Override
    protected Path getPath(FileLocation location) throws InvalidPathException {
        try {
            URL url = this.getClass().getClassLoader().getResource(location.getFile());
            if (url.getPath().contains("/BOOT-INF/classes!")) {
                URI uri = url.toURI();
                HashMap env = new HashMap();
                String[] array = uri.toString().split("!");
                if (!fsMap.containsKey(array[0])) {
                    fsMap.put(array[0], FileSystems.newFileSystem(URI.create(array[0]), env));
                }
                FileSystem fs = fsMap.get(array[0]);
                return fs.getPath(array[1], array[2]);
            }
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

