/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file.contenttype;

import com.dangdang.config.service.exception.InvalidPathException;
import com.dangdang.config.service.file.contenttype.ContentType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class XmlContentType
implements ContentType {
    @Override
    public Map<String, String> resolve(byte[] data, String encoding) throws InvalidPathException {
        Properties props = new Properties();
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            props.loadFromXML(in);
        }
        catch (IOException e) {
            throw new InvalidPathException(e);
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            propMap.put(key, props.getProperty(key));
        }
        return propMap;
    }
}

