/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.config.service.file;

import com.dangdang.config.service.ConfigGroup;
import com.dangdang.config.service.GeneralConfigGroup;
import com.dangdang.config.service.exception.InvalidPathException;
import com.dangdang.config.service.file.FileConfigProfile;
import com.dangdang.config.service.file.FileLocation;
import com.dangdang.config.service.file.contenttype.ContentType;
import com.dangdang.config.service.file.contenttype.ContentTypes;
import com.dangdang.config.service.file.protocol.Protocol;
import com.dangdang.config.service.file.protocol.Protocols;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigGroup
extends GeneralConfigGroup {
    private static final long serialVersionUID = 1L;
    private FileConfigProfile configProfile;
    private FileLocation location;
    private Protocol protocolBean;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfigGroup.class);

    public FileConfigGroup(FileConfigProfile configProfile, String location, boolean enumerable) {
        this(configProfile, location);
        this.enumerable = enumerable;
    }

    public FileConfigGroup(FileConfigProfile configProfile, String location) {
        this(null, configProfile, location);
    }

    public FileConfigGroup(ConfigGroup internalConfigGroup, FileConfigProfile configProfile, String location) {
        super(internalConfigGroup);
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null.");
        }
        this.configProfile = configProfile;
        this.location = FileLocation.fromLocation(location);
        this.initConfigs();
        try {
            this.protocolBean.watch(this.location, this);
        }
        catch (InvalidPathException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initConfigs() {
        LOGGER.debug("Loading file: {}", (Object)this.location);
        try {
            this.protocolBean = Protocols.getInstance().get(this.location.getProtocol()).newInstance();
            ContentType contentTypeBean = ContentTypes.getInstance().get(this.configProfile.getContentType()).newInstance();
            this.cleanAndPutAll(contentTypeBean.resolve(this.protocolBean.read(this.location), this.configProfile.getFileEncoding()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.protocolBean != null) {
            this.protocolBean.close();
        }
    }
}

