/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.kryo.kryo.serializers;

import com.cloudera.livy.shaded.kryo.kryo.Generics;
import com.cloudera.livy.shaded.kryo.kryo.Kryo;
import com.cloudera.livy.shaded.kryo.kryo.NotNull;
import com.cloudera.livy.shaded.kryo.kryo.Serializer;
import com.cloudera.livy.shaded.kryo.kryo.io.Input;
import com.cloudera.livy.shaded.kryo.kryo.io.Output;
import com.cloudera.livy.shaded.kryo.kryo.serializers.AsmCacheFields;
import com.cloudera.livy.shaded.kryo.kryo.serializers.FieldSerializerGenericsUtil;
import com.cloudera.livy.shaded.kryo.kryo.serializers.FieldSerializerUnsafeUtil;
import com.cloudera.livy.shaded.kryo.kryo.serializers.ObjectField;
import com.cloudera.livy.shaded.kryo.kryo.serializers.UnsafeCacheFields;
import com.cloudera.livy.shaded.kryo.kryo.util.IntArray;
import com.cloudera.livy.shaded.kryo.kryo.util.ObjectMap;
import com.cloudera.livy.shaded.kryo.kryo.util.UnsafeUtil;
import com.cloudera.livy.shaded.kryo.kryo.util.Util;
import com.cloudera.livy.shaded.kryo.minlog.Log;
import com.cloudera.livy.shaded.kryo.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    private final TypeVariable[] typeParameters;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;
    private boolean fixedFieldTypes;
    private boolean useAsmEnabled = UnsafeUtil.unsafe() != null;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private final boolean copyTransient = true;
    private final boolean serializeTransient = false;
    private boolean hasObjectFields = false;

    public FieldSerializer(Kryo kryo, Class type) {
        if (Log.TRACE) {
            Log.trace("kryo", "optimize ints is " + this.varIntsEnabled);
        }
        this.kryo = kryo;
        this.type = type;
        this.typeParameters = type.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer(Kryo, Class)");
        }
        this.rebuildCachedFields();
    }

    public FieldSerializer(Kryo kryo, Class type, Class[] generics) {
        if (Log.TRACE) {
            Log.trace("kryo", "optimize ints is " + this.varIntsEnabled);
        }
        this.kryo = kryo;
        this.type = type;
        this.generics = generics;
        this.typeParameters = type.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer(Kryo, Class, Generics)");
        }
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        Generics genScope;
        if (Log.TRACE && this.generics != null) {
            Log.trace("kryo", "generic type parameters are: " + Arrays.toString(this.generics));
        }
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        this.genericsScope = genScope = this.genericsUtil.buildGenericsScope(this.type, this.generics);
        if (this.genericsScope != null) {
            this.kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        List<Field> allFields = new ArrayList<Field>();
        for (Class nextClass = this.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Field[] declaredFields = nextClass.getDeclaredFields();
            if (declaredFields == null) continue;
            for (Field f : declaredFields) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                allFields.add(f);
            }
        }
        ObjectMap context = this.kryo.getContext();
        IntArray useAsm = new IntArray();
        if (this.useMemRegions && !this.useAsmEnabled && UnsafeUtil.unsafe() != null) {
            Field[] allFieldsArray = UnsafeUtil.sortFieldsByOffset(allFields);
            allFields = Arrays.asList(allFieldsArray);
        }
        List<Field> validFields = this.buildValidFields(false, allFields, context, useAsm);
        List<Field> validTransientFields = this.buildValidFields(true, allFields, context, useAsm);
        if (this.useAsmEnabled && !Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && useAsm.indexOf(1) != -1) {
            try {
                this.access = FieldAccess.get(this.type);
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
        }
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(validFields.size());
        ArrayList<CachedField> cachedTransientFields = new ArrayList<CachedField>(validTransientFields.size());
        this.createCachedFields(useAsm, validFields, cachedFields, 0);
        this.createCachedFields(useAsm, validTransientFields, cachedTransientFields, validFields.size());
        Collections.sort(cachedFields, this);
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        Collections.sort(cachedTransientFields, this);
        this.transientFields = cachedTransientFields.toArray(new CachedField[cachedTransientFields.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.popGenericsScope();
        }
    }

    private List<Field> buildValidFields(boolean transientFields, List<Field> allFields, ObjectMap context, IntArray useAsm) {
        ArrayList<Field> result = new ArrayList<Field>(allFields.size());
        int n = allFields.size();
        for (int i = 0; i < n; ++i) {
            Optional optional;
            Field field = allFields.get(i);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) && !transientFields || Modifier.isStatic(modifiers) || field.isSynthetic() && this.ignoreSyntheticFields) continue;
            if (!field.isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !context.containsKey(optional.value())) continue;
            result.add(field);
            useAsm.add(!Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        return result;
    }

    private void createCachedFields(IntArray useAsm, List<Field> validFields, List<CachedField> cachedFields, int baseIndex) {
        if (this.useAsmEnabled || !this.useMemRegions) {
            int n = validFields.size();
            for (int i = 0; i < n; ++i) {
                Field field = validFields.get(i);
                int accessIndex = -1;
                if (this.access != null && useAsm.get(baseIndex + i) == 1) {
                    accessIndex = ((FieldAccess)this.access).getIndex(field.getName());
                }
                cachedFields.add(this.newCachedField(field, cachedFields.size(), accessIndex));
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(validFields, cachedFields, baseIndex, useAsm);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        this.generics = generics;
        if (Log.TRACE) {
            Log.trace("kryo", "setGenerics");
        }
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields();
        }
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field, int fieldIndex, int accessIndex) {
        CachedField cachedField;
        Class[] fieldClass = new Class[]{field.getType()};
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType == fieldClass[0]) {
            if (Log.TRACE) {
                Log.trace("kryo", "Field '" + field.getName() + "' of type " + fieldClass[0]);
            }
            cachedField = this.newMatchingCachedField(field, accessIndex, fieldClass[0], fieldGenericType, null);
        } else {
            cachedField = this.genericsUtil.newCachedFieldOfGenericType(field, accessIndex, fieldClass, fieldGenericType);
        }
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.useAsmEnabled) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = accessIndex;
        boolean bl = cachedField.canBeNull = this.fieldsCanBeNull && !fieldClass[0].isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(fieldClass[0]) || this.fixedFieldTypes) {
            cachedField.valueClass = fieldClass[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field, int accessIndex, Class fieldClass, Type fieldGenericType, Class[] fieldGenerics) {
        CachedField cachedField;
        if (accessIndex != -1) {
            cachedField = fieldClass.isPrimitive() ? (fieldClass == Boolean.TYPE ? new AsmCacheFields.BooleanField() : (fieldClass == Byte.TYPE ? new AsmCacheFields.ByteField() : (fieldClass == Character.TYPE ? new AsmCacheFields.CharField() : (fieldClass == Short.TYPE ? new AsmCacheFields.ShortField() : (fieldClass == Integer.TYPE ? new AsmCacheFields.IntField() : (fieldClass == Long.TYPE ? new AsmCacheFields.LongField() : (fieldClass == Float.TYPE ? new AsmCacheFields.FloatField() : (fieldClass == Double.TYPE ? new AsmCacheFields.DoubleField() : new AsmCacheFields.AsmObjectField(this))))))))) : (!(fieldClass != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new AsmCacheFields.StringField() : new AsmCacheFields.AsmObjectField(this));
        } else if (!this.useAsmEnabled) {
            cachedField = fieldClass.isPrimitive() ? (fieldClass == Boolean.TYPE ? new UnsafeCacheFields.UnsafeBooleanField(field) : (fieldClass == Byte.TYPE ? new UnsafeCacheFields.UnsafeByteField(field) : (fieldClass == Character.TYPE ? new UnsafeCacheFields.UnsafeCharField(field) : (fieldClass == Short.TYPE ? new UnsafeCacheFields.UnsafeShortField(field) : (fieldClass == Integer.TYPE ? new UnsafeCacheFields.UnsafeIntField(field) : (fieldClass == Long.TYPE ? new UnsafeCacheFields.UnsafeLongField(field) : (fieldClass == Float.TYPE ? new UnsafeCacheFields.UnsafeFloatField(field) : (fieldClass == Double.TYPE ? new UnsafeCacheFields.UnsafeDoubleField(field) : new UnsafeCacheFields.UnsafeObjectField(this))))))))) : (!(fieldClass != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new UnsafeCacheFields.UnsafeStringField(field) : new UnsafeCacheFields.UnsafeObjectField(this));
        } else {
            cachedField = fieldClass.isPrimitive() ? (fieldClass == Boolean.TYPE ? new ObjectField.ObjectBooleanField(this) : (fieldClass == Byte.TYPE ? new ObjectField.ObjectByteField(this) : (fieldClass == Character.TYPE ? new ObjectField.ObjectCharField(this) : (fieldClass == Short.TYPE ? new ObjectField.ObjectShortField(this) : (fieldClass == Integer.TYPE ? new ObjectField.ObjectIntField(this) : (fieldClass == Long.TYPE ? new ObjectField.ObjectLongField(this) : (fieldClass == Float.TYPE ? new ObjectField.ObjectFloatField(this) : (fieldClass == Double.TYPE ? new ObjectField.ObjectDoubleField(this) : new ObjectField(this))))))))) : new ObjectField(this);
            if (fieldGenerics != null) {
                ((ObjectField)cachedField).generics = fieldGenerics;
            } else {
                Object[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
                ((ObjectField)cachedField).generics = cachedFieldGenerics;
                if (Log.TRACE) {
                    Log.trace("kryo", "Field generics: " + Arrays.toString(cachedFieldGenerics));
                }
            }
        }
        return cachedField;
    }

    @Override
    public int compare(CachedField o1, CachedField o2) {
        return o1.field.getName().compareTo(o2.field.getName());
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.fieldsCanBeNull = fieldsCanBeNull;
        if (Log.TRACE) {
            Log.trace("kryo", "setFieldsCanBeNull: " + fieldsCanBeNull);
        }
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.setFieldsAsAccessible = setFieldsAsAccessible;
        if (Log.TRACE) {
            Log.trace("kryo", "setFieldsAsAccessible: " + setFieldsAsAccessible);
        }
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.ignoreSyntheticFields = ignoreSyntheticFields;
        if (Log.TRACE) {
            Log.trace("kryo", "setIgnoreSyntheticFields: " + ignoreSyntheticFields);
        }
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.fixedFieldTypes = fixedFieldTypes;
        if (Log.TRACE) {
            Log.trace("kryo", "setFixedFieldTypes: " + fixedFieldTypes);
        }
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean setUseAsm) {
        this.useAsmEnabled = setUseAsm;
        if (Log.TRACE) {
            Log.trace("kryo", "setUseAsm: " + setUseAsm);
        }
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer.write fields of class " + object.getClass().getName());
        }
        if (this.typeParameters != null && this.generics != null) {
            this.rebuildCachedFields();
        }
        if (this.genericsScope != null) {
            kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        CachedField[] fields = this.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(output, object);
        }
        if (this.genericsScope != null) {
            kryo.popGenericsScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        try {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.pushGenericsScope(type, this.genericsScope);
            }
            T object = this.create(kryo, input, type);
            kryo.reference(object);
            CachedField[] fields = this.fields;
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                fields[i].read(input, object);
            }
            T t = object;
            return t;
        }
        finally {
            if (this.genericsScope != null && kryo.getGenericsScope() != null) {
                kryo.popGenericsScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> type) {
        return kryo.newInstance(type);
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i);
            System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
            this.fields = newFields;
            return;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.useAsmEnabled;
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        int i;
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        int n = this.transientFields.length;
        for (i = 0; i < n; ++i) {
            this.transientFields[i].copy(original, copy);
        }
        n = this.fields.length;
        for (i = 0; i < n; ++i) {
            this.fields[i].copy(original, copy);
        }
        return copy;
    }

    public final Generics getGenericsScope() {
        return this.genericsScope;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setClass(Class valueClass) {
            this.valueClass = valueClass;
            this.serializer = null;
        }

        public void setClass(Class valueClass, Serializer serializer) {
            this.valueClass = valueClass;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

