/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.jackson.databind.util;

import com.cloudera.livy.shaded.jackson.core.JsonGenerator;
import com.cloudera.livy.shaded.jackson.core.JsonProcessingException;
import com.cloudera.livy.shaded.jackson.databind.JavaType;
import com.cloudera.livy.shaded.jackson.databind.JsonSerializable;
import com.cloudera.livy.shaded.jackson.databind.SerializerProvider;
import com.cloudera.livy.shaded.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public class JSONPObject
implements JsonSerializable {
    protected final String _function;
    protected final Object _value;
    protected final JavaType _serializationType;

    public JSONPObject(String function, Object value) {
        this(function, value, null);
    }

    public JSONPObject(String function, Object value, JavaType asType) {
        this._function = function;
        this._value = value;
        this._serializationType = asType;
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeRaw(this._function);
        jgen.writeRaw('(');
        if (this._value == null) {
            provider.defaultSerializeNull(jgen);
        } else if (this._serializationType != null) {
            provider.findTypedValueSerializer(this._serializationType, true, null).serialize(this._value, jgen, provider);
        } else {
            Class<?> cls = this._value.getClass();
            provider.findTypedValueSerializer(cls, true, null).serialize(this._value, jgen, provider);
        }
        jgen.writeRaw(')');
    }

    public String getFunction() {
        return this._function;
    }

    public Object getValue() {
        return this._value;
    }

    public JavaType getSerializationType() {
        return this._serializationType;
    }
}

