/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.shaded.apache.http.protocol;

import com.cloudera.livy.shaded.apache.http.HttpEntityEnclosingRequest;
import com.cloudera.livy.shaded.apache.http.HttpException;
import com.cloudera.livy.shaded.apache.http.HttpRequest;
import com.cloudera.livy.shaded.apache.http.HttpRequestInterceptor;
import com.cloudera.livy.shaded.apache.http.annotation.ThreadSafe;
import com.cloudera.livy.shaded.apache.http.protocol.HttpContext;
import com.cloudera.livy.shaded.apache.http.protocol.HttpDateGenerator;
import com.cloudera.livy.shaded.apache.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

