/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractMapDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class JavaDeserializer
extends AbstractMapDeserializer {
    private Class _type;
    private HashMap _fieldMap;
    private Method _readResolve;
    private Constructor _constructor;
    private Object[] _constructorArgs;

    public JavaDeserializer(Class cl) {
        this._type = cl;
        this._fieldMap = this.getFieldMap(cl);
        try {
            this._readResolve = cl.getMethod("readResolve", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        int bestLength = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length >= bestLength) continue;
            this._constructor = constructors[i];
            bestLength = this._constructor.getParameterTypes().length;
        }
        if (this._constructor != null) {
            this._constructor.setAccessible(true);
            Class<?>[] params = this._constructor.getParameterTypes();
            this._constructorArgs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                this._constructorArgs[i] = JavaDeserializer.getParamArg(params[i]);
            }
        }
    }

    public Class getType() {
        return this._type;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readMap(in, obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(String.valueOf(e));
        }
    }

    public Object readMap(AbstractHessianInput in, Object obj) throws IOException {
        try {
            int ref = in.addRef(obj);
            while (!in.isEnd()) {
                Object value;
                Object key = in.readObject();
                Field field = (Field)this._fieldMap.get(key);
                if (field != null) {
                    value = in.readObject(field.getType());
                    field.set(obj, value);
                    continue;
                }
                value = in.readObject();
            }
            in.readMapEnd();
            Object resolve = this.resolve(obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(String.valueOf(e));
        }
    }

    private Object resolve(Object obj) {
        try {
            if (this._readResolve != null) {
                return this._readResolve.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected Object instantiate() throws Exception {
        if (this._constructor != null) {
            return this._constructor.newInstance(this._constructorArgs);
        }
        return this._type.newInstance();
    }

    protected HashMap getFieldMap(Class cl) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        while (cl != null) {
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || fieldMap.get(field.getName()) != null) continue;
                try {
                    field.setAccessible(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                fieldMap.put(field.getName(), field);
            }
            cl = cl.getSuperclass();
        }
        return fieldMap;
    }

    protected static Object getParamArg(Class cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(cl)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(cl)) {
            return new Double(0.0);
        }
        if (Double.TYPE.equals(cl)) {
            return new Double(0.0);
        }
        throw new UnsupportedOperationException();
    }
}

