/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.kit.DateKit;
import com.blade.kit.StringKit;
import com.blade.server.netty.HttpServerDispatcher;
import com.blade.server.netty.WebSocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerInitializer.class);
    private final HttpServerDispatcher HTTP_SERVER_HANDLER = new HttpServerDispatcher();
    private final SslContext sslCtx;
    private final Blade blade;
    private final boolean enableCors;
    private final boolean isWebSocket;
    private final boolean useGZIP;
    public static volatile CharSequence date = new AsciiString((CharSequence)DateKit.gmtDate(LocalDateTime.now()));
    private static WebSocketHandler WEB_SOCKET_HANDLER;

    public HttpServerInitializer(SslContext sslCtx, Blade blade, ScheduledExecutorService service) {
        this.sslCtx = sslCtx;
        this.blade = blade;
        this.enableCors = blade.environment().getBoolean("http.cors.enable", false);
        this.useGZIP = blade.environment().getBoolean("http.gzip.enable", false);
        this.isWebSocket = StringKit.isNotEmpty(blade.webSocketPath());
        if (this.isWebSocket) {
            WEB_SOCKET_HANDLER = new WebSocketHandler(blade);
        }
        service.scheduleWithFixedDelay(() -> {
            date = new AsciiString((CharSequence)DateKit.gmtDate(LocalDateTime.now()));
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        try {
            if (this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec(72384, 289536, 579072, false)});
            p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
            p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
            if (this.useGZIP) {
                p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
            }
            p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            if (this.enableCors) {
                p.addLast(new ChannelHandler[]{new CorsHandler(CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build())});
            }
            if (this.isWebSocket) {
                p.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.blade.webSocketPath(), null, true)});
                p.addLast(new ChannelHandler[]{WEB_SOCKET_HANDLER});
            }
            p.addLast(new ChannelHandler[]{this.HTTP_SERVER_HANDLER});
        }
        catch (Exception e) {
            log.error("Add channel pipeline error", (Throwable)e);
        }
    }
}

