/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.PathKit;
import com.blade.mvc.http.HttpMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Route {
    private HttpMethod httpMethod;
    private String path;
    private Object target;
    private Class<?> targetType;
    private Method action;
    private int sort;
    private Map<String, String> pathParams = new HashMap<String, String>(8);

    public Route(HttpMethod httpMethod, String path, Class<?> targetType, Method action) {
        this.httpMethod = httpMethod;
        this.path = PathKit.fixPath(path);
        this.targetType = targetType;
        this.action = action;
        this.sort = Integer.MAX_VALUE;
    }

    public Route(HttpMethod httpMethod, String path, Object target, Class<?> targetType, Method action) {
        this.httpMethod = httpMethod;
        this.path = PathKit.fixPath(path);
        this.target = target;
        this.targetType = targetType;
        this.action = action;
        this.sort = Integer.MAX_VALUE;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getAction() {
        return this.action;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public String getAllPath() {
        return this.path + "#" + this.httpMethod.name();
    }

    public String toString() {
        return (Object)((Object)this.httpMethod) + "\t" + this.path;
    }

    private static int $default$sort() {
        return Integer.MAX_VALUE;
    }

    public static RouteBuilder builder() {
        return new RouteBuilder();
    }

    public Route() {
    }

    public Route(HttpMethod httpMethod, String path, Object target, Class<?> targetType, Method action, int sort, Map<String, String> pathParams) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.target = target;
        this.targetType = targetType;
        this.action = action;
        this.sort = sort;
        this.pathParams = pathParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Object this$target = this.getTarget();
        Object other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Class<?> this$targetType = this.getTargetType();
        Class<?> other$targetType = other.getTargetType();
        if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
            return false;
        }
        Method this$action = this.getAction();
        Method other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        if (this.getSort() != other.getSort()) {
            return false;
        }
        Map<String, String> this$pathParams = this.getPathParams();
        Map<String, String> other$pathParams = other.getPathParams();
        return !(this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Route;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Object $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Class<?> $targetType = this.getTargetType();
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        Method $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        result = result * 59 + this.getSort();
        Map<String, String> $pathParams = this.getPathParams();
        result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        return result;
    }

    public static class RouteBuilder {
        private HttpMethod httpMethod;
        private String path;
        private Object target;
        private Class<?> targetType;
        private Method action;
        private boolean sort$set;
        private int sort;
        private Map<String, String> pathParams;

        RouteBuilder() {
        }

        public RouteBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public RouteBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RouteBuilder target(Object target) {
            this.target = target;
            return this;
        }

        public RouteBuilder targetType(Class<?> targetType) {
            this.targetType = targetType;
            return this;
        }

        public RouteBuilder action(Method action) {
            this.action = action;
            return this;
        }

        public RouteBuilder sort(int sort) {
            this.sort = sort;
            this.sort$set = true;
            return this;
        }

        public RouteBuilder pathParams(Map<String, String> pathParams) {
            this.pathParams = pathParams;
            return this;
        }

        public Route build() {
            int sort = this.sort;
            if (!this.sort$set) {
                sort = Route.$default$sort();
            }
            return new Route(this.httpMethod, this.path, this.target, this.targetType, this.action, sort, this.pathParams);
        }

        public String toString() {
            return "Route.RouteBuilder(httpMethod=" + (Object)((Object)this.httpMethod) + ", path=" + this.path + ", target=" + this.target + ", targetType=" + this.targetType + ", action=" + this.action + ", sort=" + this.sort + ", pathParams=" + this.pathParams + ")";
        }
    }
}

