/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassDefine {
    private static final ConcurrentHashMap<Class<?>, ClassDefine> pool = new ConcurrentHashMap(128);
    private final Class<?> clazz;

    private ClassDefine(Class<?> type) {
        this.clazz = type;
    }

    public static ClassDefine create(Class<?> clazz) {
        ClassDefine old;
        ClassDefine classDefine = pool.get(clazz);
        if (classDefine == null && (old = pool.putIfAbsent(clazz, classDefine = new ClassDefine(clazz))) != null) {
            classDefine = old;
        }
        return classDefine;
    }

    public <T> Class<T> getType() {
        return this.clazz;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    public ClassDefine getSuperKlass() {
        Class<?> superKlass = this.clazz.getSuperclass();
        return superKlass == null ? null : ClassDefine.create(superKlass);
    }

    public List<ClassDefine> getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        if (interfaces.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ClassDefine> results = new ArrayList<ClassDefine>(interfaces.length);
        for (Class<?> intf : interfaces) {
            results.add(ClassDefine.create(intf));
        }
        return results;
    }

    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.clazz.getAnnotation(annotationClass);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.clazz.isAnnotationPresent(annotationClass);
    }

    public Field[] getDeclaredFields() {
        return this.clazz.getDeclaredFields();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }
}

