/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.swagger;

import com.battcn.swagger.properties.SwaggerProperties;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

@Configuration
@ConditionalOnProperty(name={"spring.swagger.enabled"}, matchIfMissing=true)
@Import(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    private static final String DEFAULT_GROUP_NAME = "default";
    private static final String BASE_PATH = "/**";
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public SwaggerProperties swaggerProperties() {
        return new SwaggerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> createRestApi(SwaggerProperties swaggerProperties) {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        if (swaggerProperties.getGroups().size() == 0) {
            ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).build();
            if (swaggerProperties.getBasePath().isEmpty()) {
                swaggerProperties.getBasePath().add(BASE_PATH);
            }
            List basePath = swaggerProperties.getBasePath().stream().map(PathSelectors::ant).collect(Collectors.toList());
            ArrayList excludePath = Lists.newArrayList();
            for (String path : swaggerProperties.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).globalOperationParameters(this.buildGlobalOperationParameters(swaggerProperties.getGlobalOperationParameters())).select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or((Iterable)excludePath)), (Predicate)Predicates.or(basePath))).build();
            configurableBeanFactory.registerSingleton(DEFAULT_GROUP_NAME, (Object)docket);
            docketList.add(docket);
            return docketList;
        }
        for (String groupName : swaggerProperties.getGroups().keySet()) {
            SwaggerProperties.GroupInfo groupInfo = swaggerProperties.getGroups().get(groupName);
            SwaggerProperties.Contact contact = groupInfo.getContact();
            ApiInfo apiInfo = new ApiInfoBuilder().title(SwaggerAutoConfiguration.defaultString(groupInfo.getTitle(), swaggerProperties.getTitle())).description(SwaggerAutoConfiguration.defaultString(groupInfo.getDescription(), swaggerProperties.getDescription())).version(SwaggerAutoConfiguration.defaultString(groupInfo.getVersion(), swaggerProperties.getVersion())).license(SwaggerAutoConfiguration.defaultString(groupInfo.getLicense(), swaggerProperties.getLicense())).licenseUrl(SwaggerAutoConfiguration.defaultString(groupInfo.getLicenseUrl(), swaggerProperties.getLicenseUrl())).contact(new Contact(SwaggerAutoConfiguration.defaultString(contact.getName(), swaggerProperties.getContact().getName()), SwaggerAutoConfiguration.defaultString(contact.getUrl(), swaggerProperties.getContact().getUrl()), SwaggerAutoConfiguration.defaultString(contact.getEmail(), swaggerProperties.getContact().getEmail()))).termsOfServiceUrl(SwaggerAutoConfiguration.defaultString(groupInfo.getTermsOfServiceUrl(), swaggerProperties.getTermsOfServiceUrl())).build();
            if (groupInfo.getBasePath().isEmpty()) {
                groupInfo.getBasePath().add(BASE_PATH);
            }
            List basePath = groupInfo.getBasePath().stream().map(PathSelectors::ant).collect(Collectors.toList());
            ArrayList excludePath = Lists.newArrayList();
            for (String path : groupInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).globalOperationParameters(this.assemblyGlobalOperationParameters(swaggerProperties.getGlobalOperationParameters(), groupInfo.getGlobalOperationParameters())).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)groupInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or((Iterable)excludePath)), (Predicate)Predicates.or(basePath))).build();
            configurableBeanFactory.registerSingleton(groupName, (Object)docket);
            docketList.add(docket);
        }
        return docketList;
    }

    private List<Parameter> buildGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters) {
        ArrayList parameters = Lists.newArrayList();
        if (Objects.isNull(globalOperationParameters)) {
            return parameters;
        }
        for (SwaggerProperties.GlobalOperationParameter globalOperationParameter : globalOperationParameters) {
            parameters.add(new ParameterBuilder().name(globalOperationParameter.getName()).description(globalOperationParameter.getDescription()).modelRef((ModelReference)new ModelRef(globalOperationParameter.getModelRef())).parameterType(globalOperationParameter.getParameterType()).required(globalOperationParameter.getRequired().booleanValue()).build());
        }
        return parameters;
    }

    private List<Parameter> assemblyGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters, List<SwaggerProperties.GlobalOperationParameter> groupOperationParameters) {
        if (Objects.isNull(groupOperationParameters) || groupOperationParameters.isEmpty()) {
            return this.buildGlobalOperationParameters(globalOperationParameters);
        }
        Set groupNames = groupOperationParameters.stream().map(SwaggerProperties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        ArrayList resultOperationParameters = Lists.newArrayList();
        if (Objects.nonNull(globalOperationParameters)) {
            for (SwaggerProperties.GlobalOperationParameter parameter : globalOperationParameters) {
                if (groupNames.contains(parameter.getName())) continue;
                resultOperationParameters.add(parameter);
            }
        }
        resultOperationParameters.addAll(groupOperationParameters);
        return this.buildGlobalOperationParameters(resultOperationParameters);
    }

    private static String defaultString(String str, String defaultStr) {
        return str == null || Objects.equals(str.trim(), "") || str.length() == 0 ? defaultStr : str;
    }
}

