/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.nio;

import com.barchart.udt.EpollUDT;
import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.SelectionKeyUDT;
import com.barchart.udt.nio.SelectorProviderUDT;
import com.barchart.udt.util.HelpUDT;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorUDT
extends AbstractSelector {
    protected static final Logger log = LoggerFactory.getLogger(SelectorUDT.class);
    private final EpollUDT epollUDT = new EpollUDT();
    public final int maximimSelectorSize;
    private volatile int resultIndex;
    private final IntBuffer readBuffer;
    private final ConcurrentMap<Integer, SelectionKeyUDT> registeredKeyMap = new ConcurrentHashMap<Integer, SelectionKeyUDT>();
    private final Set<? extends SelectionKey> registeredKeySet = HelpUDT.unmodifiableSet(this.registeredKeyMap.values());
    private final ConcurrentMap<SelectionKeyUDT, SelectionKeyUDT> selectedKeyMap = new ConcurrentHashMap<SelectionKeyUDT, SelectionKeyUDT>();
    private final Set<? extends SelectionKey> selectedKeySet = HelpUDT.ungrowableSet(this.selectedKeyMap.keySet());
    private final ConcurrentMap<SelectionKeyUDT, SelectionKeyUDT> terminatedKeyMap = new ConcurrentHashMap<SelectionKeyUDT, SelectionKeyUDT>();
    private final Lock selectLock = new ReentrantLock();
    private final IntBuffer sizeBuffer;
    private volatile int wakeupBaseCount;
    private volatile int wakeupStepCount;
    private final IntBuffer writeBuffer;

    protected static Selector open(TypeUDT type) throws IOException {
        SelectorProviderUDT provider;
        switch (type) {
            case DATAGRAM: {
                provider = SelectorProviderUDT.DATAGRAM;
                break;
            }
            case STREAM: {
                provider = SelectorProviderUDT.STREAM;
                break;
            }
            default: {
                log.error("unsupported type={}", (Object)type);
                throw new IOException("unsupported type");
            }
        }
        return provider.openSelector();
    }

    protected SelectorUDT(SelectorProvider provider, int maximumSelectorSize) throws ExceptionUDT {
        super(provider);
        this.maximimSelectorSize = maximumSelectorSize;
        this.readBuffer = HelpUDT.newDirectIntBufer(maximumSelectorSize);
        this.writeBuffer = HelpUDT.newDirectIntBufer(maximumSelectorSize);
        this.sizeBuffer = HelpUDT.newDirectIntBufer(3);
    }

    protected void cancel(SelectionKeyUDT keyUDT) {
        this.terminatedKeyMap.putIfAbsent(keyUDT, keyUDT);
    }

    protected void doCancel() {
        if (this.terminatedKeyMap.isEmpty()) {
            return;
        }
        Iterator iterator = this.terminatedKeyMap.values().iterator();
        while (iterator.hasNext()) {
            SelectionKeyUDT keyUDT = (SelectionKeyUDT)iterator.next();
            iterator.remove();
            if (!keyUDT.isValid()) continue;
            keyUDT.makeValid(false);
            this.registeredKeyMap.remove(keyUDT.socketId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEpollEnter(long millisTimeout) throws IOException {
        if (!this.isOpen()) {
            log.error("slector is closed");
            throw new ClosedSelectorException();
        }
        try {
            this.selectLock.lock();
            int n = this.doEpollExclusive(millisTimeout);
            return n;
        }
        finally {
            this.selectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEpollExclusive(long millisTimeout) throws IOException {
        this.doCancel();
        this.doEpollSelect(millisTimeout);
        this.doResults();
        return this.selectedKeyMap.size();
    }

    protected int doEpollSelect(long millisTimeout) throws ExceptionUDT {
        this.wakeupMarkBase();
        int readyCount = 0;
        if (millisTimeout < 0L) {
            while ((readyCount = this.doEpollSelectUDT(10L)) <= 0 && !this.wakeupIsPending()) {
            }
        } else if (millisTimeout > 0L) {
            while ((readyCount = this.doEpollSelectUDT(10L)) <= 0 && !this.wakeupIsPending() && (millisTimeout -= 10L) > 0L) {
            }
        } else {
            readyCount = this.doEpollSelectUDT(0L);
        }
        return readyCount;
    }

    protected int doEpollSelectUDT(long timeout) throws ExceptionUDT {
        return SocketUDT.selectEpoll(this.epollUDT.id(), this.readBuffer, this.writeBuffer, this.sizeBuffer, timeout);
    }

    protected void doResults() {
        int resultIndex = this.resultIndex++;
        this.doResultsRead(resultIndex);
        this.doResultsWrite(resultIndex);
    }

    protected void doResultsRead(int resultIndex) {
        int readSize = this.sizeBuffer.get(0);
        for (int index = 0; index < readSize; ++index) {
            int socketId = this.readBuffer.get(index);
            SelectionKeyUDT keyUDT = (SelectionKeyUDT)this.registeredKeyMap.get(socketId);
            if (!keyUDT.doRead(resultIndex)) continue;
            this.selectedKeyMap.putIfAbsent(keyUDT, keyUDT);
        }
    }

    protected void doResultsWrite(int resultIndex) {
        int writeSize = this.sizeBuffer.get(1);
        for (int index = 0; index < writeSize; ++index) {
            int socketId = this.writeBuffer.get(index);
            SelectionKeyUDT keyUDT = (SelectionKeyUDT)this.registeredKeyMap.get(socketId);
            if (!keyUDT.doWrite(resultIndex)) continue;
            this.selectedKeyMap.putIfAbsent(keyUDT, keyUDT);
        }
    }

    protected EpollUDT epollUDT() {
        return this.epollUDT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelector() throws IOException {
        this.wakeup();
        try {
            this.selectLock.lock();
            for (SelectionKeyUDT keyUDT : this.registeredKeyMap.values()) {
                this.cancel(keyUDT);
            }
        }
        finally {
            this.selectLock.unlock();
        }
        this.doCancel();
    }

    @Override
    public Set<SelectionKey> keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.registeredKeySet;
    }

    @Override
    protected SelectionKey register(AbstractSelectableChannel channel, int interestOps, Object attachment) {
        if (this.registeredKeyMap.size() >= this.maximimSelectorSize) {
            log.error("reached maximimSelectorSize");
            throw new IllegalSelectorException();
        }
        if (!(channel instanceof ChannelUDT)) {
            log.error("!(channel instanceof ChannelUDT)");
            throw new IllegalSelectorException();
        }
        ChannelUDT channelUDT = (ChannelUDT)((Object)channel);
        Integer socketId = channelUDT.socketUDT().id();
        SelectionKeyUDT keyUDT = (SelectionKeyUDT)this.registeredKeyMap.get(socketId);
        if (keyUDT == null) {
            keyUDT = new SelectionKeyUDT(this, channelUDT, attachment);
            this.registeredKeyMap.putIfAbsent(socketId, keyUDT);
            keyUDT = (SelectionKeyUDT)this.registeredKeyMap.get(socketId);
        }
        keyUDT.interestOps(interestOps);
        return keyUDT;
    }

    @Override
    public int select() throws IOException {
        return this.select(0L);
    }

    @Override
    public int select(long timeout) throws IOException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("negative timeout");
        }
        if (timeout > 0L) {
            return this.doEpollEnter(timeout);
        }
        return this.doEpollEnter(-1L);
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selectedKeySet;
    }

    @Override
    public int selectNow() throws IOException {
        return this.doEpollEnter(SocketUDT.TIMEOUT_NONE);
    }

    @Override
    public Selector wakeup() {
        ++this.wakeupStepCount;
        return this;
    }

    protected boolean wakeupIsPending() {
        return this.wakeupBaseCount != this.wakeupStepCount;
    }

    protected void wakeupMarkBase() {
        this.wakeupBaseCount = this.wakeupStepCount;
    }
}

