/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.DynamicDataSourceClassResolver;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final String DYNAMIC_PREFIX = "#";
    private DsProcessor dsProcessor;
    private DynamicDataSourceClassResolver dynamicDataSourceClassResolver = new DynamicDataSourceClassResolver();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            DynamicDataSourceContextHolder.setDataSourceLookupKey(this.determineDatasource(invocation));
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
    }

    private String determineDatasource(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Class<?> declaringClass = this.dynamicDataSourceClassResolver.targetClass(invocation);
        DS ds = method.isAnnotationPresent(DS.class) ? method.getAnnotation(DS.class) : (DS)AnnotationUtils.findAnnotation(declaringClass, DS.class);
        String key = ds.value();
        return !key.isEmpty() && key.startsWith(DYNAMIC_PREFIX) ? this.dsProcessor.determineDatasource(invocation, key) : key;
    }

    public void setDsProcessor(DsProcessor dsProcessor) {
        this.dsProcessor = dsProcessor;
    }
}

