/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.CodeGenerator;
import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.ICodeGenerator;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.CodePrinter;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProtobufProxy {
    public static final ThreadLocal<Boolean> DEBUG_CONTROLLER = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(ProtobufProxy.class.getName());
    private static final Map<String, Codec> CACHED = new ConcurrentHashMap<String, Codec>();
    public static final ThreadLocal<File> OUTPUT_PATH = new ThreadLocal();

    public static void dynamicCodeGenerate(OutputStream os, Class cls, Charset charset) throws IOException {
        if (cls == null) {
            throw new NullPointerException("Parameter cls is null");
        }
        if (os == null) {
            throw new NullPointerException("Parameter os is null");
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        ICodeGenerator cg = ProtobufProxy.getCodeGenerator(cls);
        String code = cg.getCode();
        os.write(code.getBytes(charset));
    }

    private static ICodeGenerator getCodeGenerator(Class cls) {
        List<Field> fields;
        if (!cls.isMemberClass()) {
            try {
                cls.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException("Class '" + cls.getName() + "' must has default constructor method with no parameters.", e2);
            }
            catch (SecurityException e2) {
                throw new IllegalArgumentException(e2.getMessage(), e2);
            }
        }
        if ((fields = FieldUtils.findMatchedFields(cls, Protobuf.class)).isEmpty()) {
            throw new IllegalArgumentException("Invalid class [" + cls.getName() + "] no field use annotation @" + Protobuf.class.getName() + " at class " + cls.getName());
        }
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields);
        CodeGenerator cg = new CodeGenerator(fieldInfos, cls);
        return cg;
    }

    public static <T> Codec<T> create(Class<T> cls) {
        Boolean debug = DEBUG_CONTROLLER.get();
        if (debug == null) {
            debug = false;
        }
        return ProtobufProxy.create(cls, debug, null);
    }

    public static <T> Codec<T> create(Class<T> cls, Compiler compiler, ICodeGenerator codeGenerator) {
        Boolean debug = DEBUG_CONTROLLER.get();
        if (debug == null) {
            debug = false;
        }
        return ProtobufProxy.create(cls, debug, null, compiler, codeGenerator);
    }

    public static void compile(Class<?> cls, File outputPath) {
        if (outputPath == null) {
            throw new NullPointerException("Param 'outputPath' is null.");
        }
        if (!outputPath.isDirectory()) {
            throw new RuntimeException("Param 'outputPath' value should be a path directory.");
        }
    }

    public static <T> Codec<T> create(Class<T> cls, boolean debug) {
        return ProtobufProxy.create(cls, debug, null);
    }

    public static <T> Codec<T> create(Class<T> cls, boolean debug, File path) {
        return ProtobufProxy.create(cls, debug, path, JDKCompilerHelper.getJdkCompiler(), ProtobufProxy.getCodeGenerator(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Codec<T> create(Class<T> cls, boolean debug, File path, Compiler compiler, ICodeGenerator codeGenerator) {
        DEBUG_CONTROLLER.set(debug);
        OUTPUT_PATH.set(path);
        try {
            Codec<T> codec = ProtobufProxy.doCreate(cls, debug, compiler, codeGenerator);
            return codec;
        }
        finally {
            DEBUG_CONTROLLER.remove();
            OUTPUT_PATH.remove();
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return contextClassLoader;
    }

    protected static <T> Codec<T> doCreate(Class<T> cls, boolean debug, Compiler compiler, ICodeGenerator cg) {
        if (cls == null) {
            throw new NullPointerException("Parameter cls is null");
        }
        String uniClsName = cls.getName();
        Codec codec = CACHED.get(uniClsName);
        if (codec != null) {
            return codec;
        }
        cg.setDebug(debug);
        File path = OUTPUT_PATH.get();
        cg.setOutputPath(path);
        String className = cg.getFullClassName();
        Class<?> c = null;
        try {
            c = Class.forName(className, true, ProtobufProxy.getClassLoader());
        }
        catch (ClassNotFoundException e1) {
            c = null;
        }
        if (c != null) {
            try {
                Codec newInstance = (Codec)c.newInstance();
                if (!CACHED.containsKey(uniClsName)) {
                    CACHED.put(uniClsName, newInstance);
                }
                return newInstance;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        String code = cg.getCode();
        if (debug) {
            String printCode = code;
            CodePrinter.printCode(printCode, "generate protobuf proxy code");
        }
        FileOutputStream fos = null;
        if (path != null && path.isDirectory()) {
            String pkg = "";
            if (className.indexOf(46) != -1) {
                pkg = StringUtils.substringBeforeLast(className, ".");
            }
            String dir = path + File.separator + pkg.replace('.', File.separatorChar);
            File f = new File(dir);
            f.mkdirs();
            try {
                fos = new FileOutputStream(new File(f, cg.getClassName() + ".class"));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        long lastModify = ClassHelper.getLastModifyTime(cls);
        if (compiler == null) {
            compiler = JDKCompilerHelper.getJdkCompiler();
        }
        Class<?> newClass = compiler.compile(className, code, cls.getClassLoader(), fos, lastModify);
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            Codec newInstance = (Codec)newClass.newInstance();
            if (!CACHED.containsKey(uniClsName)) {
                CACHED.put(uniClsName, newInstance);
            }
            try {
                Set<Class<?>> relativeProxyClasses = cg.getRelativeProxyClasses();
                for (Class<?> relativeClass : relativeProxyClasses) {
                    ProtobufProxy.create(relativeClass, debug, path);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e.getMessage(), e.getCause());
            }
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void clearCache() {
        CACHED.clear();
    }
}

